/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.functions;

import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.functions.Function;
import com.wynntils.core.consumers.functions.arguments.Argument;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.services.hades.HadesUser;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.type.CappedValue;
import java.util.List;
import net.minecraft.class_1074;

public class HadesPartyFunctions {

    public static class HadesPartyMemberNameFunction
    extends HadesPartyFunctionBase<String> {
        @Override
        public String processMember(HadesUser member) {
            return member.getName();
        }

        @Override
        public String whenAbsent() {
            return "";
        }
    }

    public static class HadesPartyMemberLocationFunction
    extends HadesPartyFunctionBase<Location> {
        @Override
        public Location processMember(HadesUser member) {
            return member.getMapLocation().asLocation();
        }

        @Override
        public Location whenAbsent() {
            return new Location(0, 0, 0);
        }
    }

    public static class HadesPartyMemberManaFunction
    extends HadesPartyFunctionBase<CappedValue> {
        @Override
        public CappedValue processMember(HadesUser member) {
            return member.getMana();
        }

        @Override
        public CappedValue whenAbsent() {
            return CappedValue.EMPTY;
        }
    }

    public static class HadesPartyMemberHealthFunction
    extends HadesPartyFunctionBase<CappedValue> {
        @Override
        public CappedValue processMember(HadesUser member) {
            return member.getHealth();
        }

        @Override
        public CappedValue whenAbsent() {
            return CappedValue.EMPTY;
        }
    }

    private static abstract class HadesPartyFunctionBase<T>
    extends Function<T> {
        private HadesPartyFunctionBase() {
        }

        @Override
        public T getValue(FunctionArguments arguments) {
            int index = arguments.getArgument("index").getIntegerValue();
            List<HadesUser> members = Services.Hades.getHadesUsers().toList();
            return !members.isEmpty() && index >= 0 && members.size() >= index ? this.processMember(members.get(index)) : this.whenAbsent();
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("index", Integer.class, null)));
        }

        @Override
        public String getArgumentDescription(String argumentName) {
            return class_1074.method_4662((String)("function.wynntils.hadesPartyFunctionBase.argument." + argumentName), (Object[])new Object[0]);
        }

        public abstract T processMember(HadesUser var1);

        public abstract T whenAbsent();
    }
}

