/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.hades.protocol.io;

import com.wynntils.hades.protocol.interfaces.HadesPacket;
import com.wynntils.hades.protocol.packets.PacketRegistry;
import com.wynntils.hades.utils.HadesBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;

public class HadesPacketEncoder
extends MessageToByteEncoder<HadesPacket<?>> {
    private final PacketRegistry registry;
    private final HadesBuffer buffer = new HadesBuffer();

    public HadesPacketEncoder(PacketRegistry registry) {
        this.registry = registry;
    }

    protected void encode(ChannelHandlerContext ctx, HadesPacket<?> msg, ByteBuf out) {
        this.buffer.setBuffer(out);
        int packetId = this.registry.getPacketId(msg.getClass());
        this.buffer.writeVarInt(packetId);
        msg.writeData(this.buffer);
    }
}

