/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.chat;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handler;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.mod.event.WynncraftConnectionEvent;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.chat.type.MessageType;
import com.wynntils.handlers.chat.type.NpcDialogueType;
import com.wynntils.handlers.chat.type.RecipientType;
import com.wynntils.mc.event.MobEffectEvent;
import com.wynntils.mc.event.SystemMessageEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.StyledTextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_1294;
import net.minecraft.class_2561;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class ChatHandler
extends Handler {
    private static final Pattern NPC_CONFIRM_PATTERN = Pattern.compile("^ *\u00a7[47]Press \u00a7[cf](SNEAK|SHIFT) \u00a7[47]to continue$");
    private static final Pattern NPC_SELECT_PATTERN = Pattern.compile("^ *\u00a7[47cf](Select|CLICK) \u00a7[47cf]an option (\u00a7[47])?to continue$");
    private static final Pattern EMPTY_LINE_PATTERN = Pattern.compile("^\\s*(\u00a7r|\u00c0+)?\\s*$");
    private static final long SLOWDOWN_PACKET_TICK_DELAY = 20L;
    private static final int CHAT_SCREEN_TICK_DELAY = 1;
    private String lastRealChat = null;
    private String oneBeforeLastRealChat = null;
    private long lastSlowdownApplied = 0L;
    private List<StyledText> lastScreenNpcDialogue = List.of();
    private StyledText lastConfirmationlessDialogue = null;
    private List<StyledText> delayedDialogue;
    private NpcDialogueType delayedType;
    private long chatScreenTicks = 0L;
    private List<StyledText> collectedLines = new ArrayList<StyledText>();

    @SubscribeEvent
    public void onConnectionChange(WynncraftConnectionEvent.Connected event) {
        this.collectedLines = new ArrayList<StyledText>();
        this.chatScreenTicks = 0L;
        this.lastRealChat = null;
        this.oneBeforeLastRealChat = null;
        this.lastSlowdownApplied = 0L;
        this.lastScreenNpcDialogue = List.of();
        this.lastConfirmationlessDialogue = null;
        this.delayedDialogue = null;
        this.delayedType = NpcDialogueType.NONE;
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (this.collectedLines.isEmpty()) {
            return;
        }
        long ticks = McUtils.mc().field_1687.method_8510();
        if (ticks >= this.chatScreenTicks + 1L) {
            this.processCollectedChatScreen();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSystemChatReceived(SystemMessageEvent.ChatReceivedEvent event) {
        if (this.shouldSeparateNPC()) {
            this.handleWithSeparation(event);
        } else {
            this.handleIncomingChatLine(event);
        }
    }

    @SubscribeEvent
    public void onStatusEffectUpdate(MobEffectEvent.Update event) {
        if (event.getEntity() != McUtils.player()) {
            return;
        }
        if (event.getEffect().equals(class_1294.field_5909.comp_349()) && event.getEffectAmplifier() == 3 && event.getEffectDurationTicks() == Short.MAX_VALUE) {
            if (this.delayedDialogue != null) {
                List<StyledText> dialogue = this.delayedDialogue;
                this.delayedDialogue = null;
                this.handleNpcDialogue(dialogue, this.delayedType, true);
            } else {
                this.lastSlowdownApplied = McUtils.mc().field_1687.method_8510();
            }
        }
    }

    @SubscribeEvent
    public void onStatusEffectRemove(MobEffectEvent.Remove event) {
        if (event.getEntity() != McUtils.player()) {
            return;
        }
        if (event.getEffect().equals(class_1294.field_5909.comp_349())) {
            this.lastSlowdownApplied = 0L;
        }
    }

    public boolean hasSlowdown() {
        return this.lastSlowdownApplied != 0L;
    }

    private void handleIncomingChatLine(SystemMessageEvent.ChatReceivedEvent event) {
        StyledText styledText = StyledText.fromComponent(event.getMessage());
        StyledText updatedMessage = this.postChatLine(styledText, MessageType.FOREGROUND);
        if (updatedMessage == null) {
            event.setCanceled(true);
        } else if (!updatedMessage.equals(styledText)) {
            event.setMessage((class_2561)updatedMessage.getComponent());
        }
    }

    private void handleWithSeparation(SystemMessageEvent.ChatReceivedEvent event) {
        StyledText styledText = StyledText.fromComponent(event.getMessage());
        long currentTicks = McUtils.mc().field_1687.method_8510();
        List<StyledText> lines = StyledTextUtils.splitInLines(styledText);
        if (lines.size() > 1 || styledText.isEmpty() && currentTicks <= this.chatScreenTicks + 1L) {
            if (currentTicks <= this.chatScreenTicks + 1L) {
                this.collectedLines.addAll(lines);
            } else {
                if (this.chatScreenTicks != 0L) {
                    this.processCollectedChatScreen();
                }
                this.collectedLines = new ArrayList<StyledText>(lines);
                this.chatScreenTicks = currentTicks;
            }
            event.setCanceled(true);
        } else {
            if (this.chatScreenTicks != 0L) {
                this.processCollectedChatScreen();
            }
            this.handleIncomingChatLine(event);
        }
    }

    private void processCollectedChatScreen() {
        ArrayList<StyledText> lines = new ArrayList<StyledText>(this.collectedLines);
        this.collectedLines = new ArrayList<StyledText>();
        this.chatScreenTicks = 0L;
        Collections.reverse(lines);
        LinkedList<StyledText> newLines = new LinkedList<StyledText>();
        if (this.lastRealChat == null) {
            lines.forEach(newLines::addLast);
        } else {
            StyledText line;
            String plainText;
            Iterator iterator = lines.iterator();
            while (iterator.hasNext() && !(plainText = (line = (StyledText)iterator.next()).getStringWithoutFormatting()).equals(this.lastRealChat)) {
                if (plainText.equals(this.oneBeforeLastRealChat)) {
                    this.lastRealChat = this.oneBeforeLastRealChat;
                    this.oneBeforeLastRealChat = null;
                    break;
                }
                newLines.addLast(line);
            }
        }
        if (newLines.isEmpty()) {
            this.handleNpcDialogue(List.of(), NpcDialogueType.NONE, false);
            return;
        }
        boolean expectedConfirmationlessDialogue = false;
        if (((StyledText)newLines.getLast()).getString().isEmpty()) {
            if (newLines.size() == 2) {
                if (newLines.getFirst().matches(EMPTY_LINE_PATTERN)) {
                    WynntilsMod.info("[NPC] - Confirmationless dialogue preparation screen detected");
                    return;
                }
                WynntilsMod.info("[NPC] - Line expected to be a confirmationless dialogue: " + String.valueOf(newLines.getFirst()));
                expectedConfirmationlessDialogue = true;
            } else if (newLines.size() == 4 && newLines.get(0).matches(EMPTY_LINE_PATTERN) && newLines.get(1).matches(EMPTY_LINE_PATTERN) && !newLines.get(2).matches(EMPTY_LINE_PATTERN) && newLines.get(3).matches(EMPTY_LINE_PATTERN)) {
                WynntilsMod.info("[NPC] - Temporary confirmationless dialogue detected");
                expectedConfirmationlessDialogue = true;
                newLines.removeFirst();
                newLines.removeFirst();
            }
            newLines.removeLast();
        }
        this.processNewLines(newLines, expectedConfirmationlessDialogue);
    }

    private void processNewLines(LinkedList<StyledText> newLines, boolean expectedConfirmationlessDialogue) {
        LinkedList<StyledText> newChatLines = new LinkedList<StyledText>();
        LinkedList<StyledText> dialogue = new LinkedList<StyledText>();
        StyledText firstText = newLines.getFirst();
        boolean isNpcConfirm = firstText.find(NPC_CONFIRM_PATTERN);
        boolean isNpcSelect = firstText.find(NPC_SELECT_PATTERN);
        if (isNpcConfirm || isNpcSelect) {
            newLines.removeFirst();
            if (newLines.isEmpty()) {
                WynntilsMod.info("[NPC] - Control message appended to the last dialogue");
                return;
            }
            if (newLines.getFirst().getString().isEmpty()) {
                newLines.removeFirst();
            } else {
                WynntilsMod.warn("Malformed dialog [#1]: " + String.valueOf(newLines.getFirst()));
            }
            boolean dialogDone = false;
            boolean optionsFound = !isNpcSelect;
            for (StyledText line : newLines) {
                if (!dialogDone) {
                    if (line.find(EMPTY_LINE_PATTERN)) {
                        if (!optionsFound) {
                            optionsFound = true;
                            dialogue.push(line);
                            continue;
                        }
                        dialogDone = true;
                        continue;
                    }
                    dialogue.push(line);
                    continue;
                }
                if (line.find(EMPTY_LINE_PATTERN)) continue;
                newChatLines.push(line);
            }
        } else {
            if (expectedConfirmationlessDialogue) {
                if (newLines.size() != 1) {
                    WynntilsMod.warn("New lines has an unexpected dialogue count [#1]: " + String.valueOf(newLines));
                }
                this.handleNpcDialogue(List.of(newLines.getFirst()), NpcDialogueType.CONFIRMATIONLESS, false);
                return;
            }
            while (!newLines.isEmpty() && newLines.getFirst().find(EMPTY_LINE_PATTERN)) {
                newLines.removeFirst();
            }
            Collections.reverse(newLines);
            while (!newLines.isEmpty()) {
                StyledText line = newLines.removeFirst();
                if (line.find(EMPTY_LINE_PATTERN)) {
                    if (newLines.isEmpty()) break;
                    StyledText nextLine = newLines.getFirst();
                    if (nextLine.equals(this.lastConfirmationlessDialogue)) {
                        if (newLines.size() <= 1) break;
                        WynntilsMod.warn("Unexpected lines after a confirmationless dialogue: " + String.valueOf(newLines));
                        break;
                    }
                    for (StyledText dialogueLine : this.lastScreenNpcDialogue) {
                        StyledText nextDialogueLine;
                        if (newLines.isEmpty() || !(nextDialogueLine = newLines.getFirst()).equals(dialogueLine)) break;
                        newLines.removeFirst();
                    }
                    if (newLines.isEmpty()) break;
                }
                newChatLines.addLast(line);
            }
        }
        newChatLines.forEach(this::handleFakeChatLine);
        this.handleScreenNpcDialog(dialogue, isNpcSelect);
    }

    private void handleScreenNpcDialog(List<StyledText> dialogues, boolean isSelection) {
        NpcDialogueType type;
        if (dialogues.isEmpty()) {
            this.handleNpcDialogue(dialogues, NpcDialogueType.NONE, false);
            return;
        }
        NpcDialogueType npcDialogueType = type = isSelection ? NpcDialogueType.SELECTION : NpcDialogueType.NORMAL;
        if (McUtils.mc().field_1687.method_8510() <= this.lastSlowdownApplied + 20L) {
            this.handleNpcDialogue(dialogues, type, true);
            return;
        }
        this.delayedDialogue = dialogues;
        this.delayedType = type;
        Managers.TickScheduler.scheduleNextTick(() -> {
            if (this.delayedDialogue != null) {
                List<StyledText> dialogToSend = this.delayedDialogue;
                this.delayedDialogue = null;
                this.handleNpcDialogue(dialogToSend, this.delayedType, false);
            }
        });
    }

    private void handleFakeChatLine(StyledText styledText) {
        if (styledText.isEmpty()) {
            return;
        }
        RecipientType recipientType = this.getRecipientType(styledText, MessageType.FOREGROUND);
        if (recipientType == RecipientType.NPC) {
            this.handleNpcDialogue(List.of(styledText), NpcDialogueType.CONFIRMATIONLESS, false);
            return;
        }
        StyledText updatedMessage = this.postChatLine(styledText, MessageType.BACKGROUND);
        if (updatedMessage == null) {
            return;
        }
        McUtils.sendMessageToClient((class_2561)updatedMessage.getComponent());
    }

    private StyledText postChatLine(StyledText styledText, MessageType messageType) {
        String plainText = styledText.getStringWithoutFormatting();
        if (!plainText.isBlank()) {
            this.oneBeforeLastRealChat = this.lastRealChat;
            this.lastRealChat = plainText;
        }
        WynntilsMod.info("[CHAT] " + styledText.getString().replace("\u00a7", "&"));
        RecipientType recipientType = this.getRecipientType(styledText, messageType);
        if (recipientType == RecipientType.NPC) {
            if (this.shouldSeparateNPC()) {
                this.handleNpcDialogue(List.of(styledText), NpcDialogueType.CONFIRMATIONLESS, false);
                return null;
            }
            recipientType = RecipientType.INFO;
        }
        ChatMessageEvent.Match receivedEvent = new ChatMessageEvent.Match(styledText, messageType, recipientType);
        WynntilsMod.postEvent(receivedEvent);
        if (receivedEvent.isCanceled()) {
            return null;
        }
        ChatMessageEvent.Edit rewriteEvent = new ChatMessageEvent.Edit(styledText, messageType, recipientType);
        WynntilsMod.postEvent(rewriteEvent);
        ChatMessageEvent.Discard discardEvent = new ChatMessageEvent.Discard(rewriteEvent.getMessage(), messageType, recipientType);
        WynntilsMod.postEvent(discardEvent);
        if (discardEvent.isCanceled()) {
            return null;
        }
        return rewriteEvent.getMessage();
    }

    private void handleNpcDialogue(List<StyledText> dialogue, NpcDialogueType type, boolean isProtected) {
        if (type == NpcDialogueType.NONE) {
            this.delayedDialogue = null;
        }
        if (type == NpcDialogueType.CONFIRMATIONLESS) {
            if (dialogue.size() != 1) {
                WynntilsMod.warn("Confirmationless dialogues should only have one line: " + String.valueOf(dialogue));
            }
            this.lastConfirmationlessDialogue = dialogue.getFirst();
        } else {
            if (this.lastScreenNpcDialogue.equals(dialogue)) {
                return;
            }
            this.lastScreenNpcDialogue = dialogue;
        }
        Models.NpcDialogue.handleDialogue(dialogue, isProtected, type);
    }

    private RecipientType getRecipientType(StyledText codedMessage, MessageType messageType) {
        for (RecipientType recipientType : RecipientType.values()) {
            if (!recipientType.matchPattern(codedMessage, messageType)) continue;
            return recipientType;
        }
        return RecipientType.INFO;
    }

    private boolean shouldSeparateNPC() {
        return Models.NpcDialogue.isNpcDialogExtractionRequired();
    }
}

