/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.container.scriptedquery;

import com.wynntils.core.WynntilsMod;
import com.wynntils.handlers.container.scriptedquery.ConditionalQueryStep;
import com.wynntils.handlers.container.scriptedquery.FixedQueryStep;
import com.wynntils.handlers.container.scriptedquery.QueryStep;
import com.wynntils.handlers.container.scriptedquery.RepeatedQueryStep;
import com.wynntils.handlers.container.scriptedquery.ScriptedContainerQuery;
import com.wynntils.handlers.container.type.ContainerAction;
import com.wynntils.handlers.container.type.ContainerPredicate;
import java.util.LinkedList;
import java.util.function.Consumer;

public final class QueryBuilder {
    private static final Consumer<String> DEFAULT_ERROR_HANDLER = errorMsg -> WynntilsMod.warn("Error in ScriptedContainerQuery: " + errorMsg);
    private final String name;
    private final LinkedList<QueryStep> steps = new LinkedList();
    private Consumer<String> errorHandler = DEFAULT_ERROR_HANDLER;

    QueryBuilder(String name) {
        this.name = name;
    }

    public QueryBuilder onError(Consumer<String> errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public QueryBuilder then(QueryStep step) {
        this.steps.add(step);
        return this;
    }

    public QueryBuilder conditionalThen(ContainerPredicate predicate, QueryStep step) {
        this.steps.add(new ConditionalQueryStep(predicate, step));
        return this;
    }

    public QueryBuilder repeat(ContainerPredicate containerCheck, QueryStep step) {
        this.steps.add(new RepeatedQueryStep(containerCheck, step));
        return this;
    }

    public QueryBuilder reprocess(ContainerAction action) {
        this.steps.add(new FixedQueryStep().processIncomingContainer(action));
        return this;
    }

    public QueryBuilder execute(Runnable r) {
        return this.reprocess(c -> r.run());
    }

    public ScriptedContainerQuery build() {
        return new ScriptedContainerQuery(this.name, this.steps, this.errorHandler);
    }
}

