/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.item;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handler;
import com.wynntils.core.mod.type.CrashType;
import com.wynntils.core.text.PartStyle;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.handlers.item.ItemAnnotator;
import com.wynntils.handlers.item.event.ItemRenamedEvent;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.event.ContainerSetSlotEvent;
import com.wynntils.mc.event.SetEntityDataEvent;
import com.wynntils.mc.event.SetSlotEvent;
import com.wynntils.mc.extension.ItemStackExtension;
import com.wynntils.models.items.WynnItem;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_2945;
import net.minecraft.class_8113;
import net.minecraft.class_9334;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class ItemHandler
extends Handler {
    private static final List<class_1792> WILDCARD_ITEMS = List.of(class_1802.field_8250, class_1802.field_8377);
    private final List<ItemAnnotator> annotators = new ArrayList<ItemAnnotator>();
    private final Map<Class<?>, Integer> profilingTimes = new HashMap();
    private final Map<Class<?>, Integer> profilingCounts = new HashMap();
    private final List<ItemAnnotator> crashedAnnotators = new ArrayList<ItemAnnotator>();
    private final List<Pattern> knownMarkerNames = new ArrayList<Pattern>();
    private final List<Pattern> simplifiablePatterns = new ArrayList<Pattern>();

    public void registerKnownMarkerNames(List<Pattern> markerPatterns) {
        this.knownMarkerNames.addAll(markerPatterns);
    }

    public void addSimplifiablePatterns(Pattern ... patterns) {
        Collections.addAll(this.simplifiablePatterns, patterns);
    }

    public static Optional<ItemAnnotation> getItemStackAnnotation(class_1799 itemStack) {
        if (itemStack == null) {
            return Optional.empty();
        }
        ItemAnnotation annotation = ((ItemStackExtension)itemStack).getAnnotation();
        return Optional.ofNullable(annotation);
    }

    public void registerAnnotator(ItemAnnotator annotator) {
        this.annotators.add(annotator);
    }

    public void updateItem(class_1799 itemStack, ItemAnnotation annotation, StyledText name) {
        ItemStackExtension itemStackExtension = (ItemStackExtension)itemStack;
        itemStackExtension.setAnnotation(annotation);
        itemStackExtension.setOriginalName(name);
        annotation.onUpdate(itemStack);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onSetSlot(SetSlotEvent.Pre event) {
        this.onItemStackUpdate(event.getContainer().method_5438(event.getSlot()), event.getItemStack());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onContainerSetSlot(ContainerSetSlotEvent.Pre event) {
        class_2371 existingItems;
        if (event.getContainerId() == 0) {
            existingItems = McUtils.inventoryMenu().method_7602();
        } else if (event.getContainerId() == McUtils.containerMenu().field_7763) {
            existingItems = McUtils.containerMenu().method_7602();
        } else {
            this.annotate(event.getItemStack());
            return;
        }
        this.onItemStackUpdate((class_1799)existingItems.get(event.getSlot()), event.getItemStack());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onContainerSetContent(ContainerSetContentEvent.Pre event) {
        class_2371 existingItems;
        if (event.getContainerId() == 0) {
            existingItems = McUtils.inventoryMenu().method_7602();
        } else if (event.getContainerId() == McUtils.containerMenu().field_7763) {
            existingItems = McUtils.containerMenu().method_7602();
        } else {
            List<class_1799> newItems = event.getItems();
            for (class_1799 newItem : newItems) {
                this.annotate(newItem);
            }
            return;
        }
        List<class_1799> newItems = event.getItems();
        for (int i = 0; i < newItems.size(); ++i) {
            this.onItemStackUpdate((class_1799)existingItems.get(i), newItems.get(i));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntitySpawn(SetEntityDataEvent event) {
        class_1297 entity = McUtils.mc().field_1687.method_8469(event.getId());
        int itemId = -1;
        if (entity instanceof class_1542) {
            itemId = class_1542.field_7199.comp_2327();
        } else if (entity instanceof class_8113.class_8122) {
            itemId = class_8113.class_8122.field_42423.comp_2327();
        }
        if (itemId == -1) {
            return;
        }
        for (class_2945.class_7834<?> packedItem : event.getPackedItems()) {
            if (packedItem.comp_1115() != itemId) continue;
            Object object = packedItem.comp_1117();
            if (!(object instanceof class_1799)) {
                return;
            }
            class_1799 itemStack = (class_1799)object;
            this.annotate(itemStack);
            return;
        }
    }

    private void onItemStackUpdate(class_1799 existingItem, class_1799 newItem) {
        if (((ItemStackExtension)newItem).getAnnotation() != null) {
            return;
        }
        ItemAnnotation annotation = ((ItemStackExtension)existingItem).getAnnotation();
        if (annotation == null) {
            this.annotate(newItem);
            return;
        }
        if (!(this.similarStack(existingItem, newItem) || this.isWildcardItem(existingItem) || this.isWildcardItem(newItem))) {
            this.annotate(newItem);
            return;
        }
        StyledText originalName = ((ItemStackExtension)existingItem).getOriginalName();
        StyledText existingName = StyledText.fromComponent(existingItem.method_7964()).getNormalized();
        StyledText newName = StyledText.fromComponent(newItem.method_7964()).getNormalized();
        if (newName.equals(existingName)) {
            if (this.isLoreSoftMatching(existingItem, newItem)) {
                this.updateItem(newItem, annotation, originalName);
            } else {
                this.annotate(newItem);
            }
        } else if (this.isKnownMarkerName(newName)) {
            boolean loreMatch = this.isLoreSoftMatching(existingItem, newItem);
            if (!loreMatch) {
                annotation = this.calculateAnnotation(newItem, originalName);
            }
            this.updateItem(newItem, annotation, originalName);
            ItemRenamedEvent event = new ItemRenamedEvent(newItem, existingName, newName);
            WynntilsMod.postEvent(event);
            if (event.isCanceled()) {
                newItem.method_57379(class_9334.field_49631, (Object)existingItem.method_7964());
            }
        } else {
            this.annotate(newItem);
        }
    }

    private boolean isKnownMarkerName(StyledText newName) {
        String name = newName.getString();
        for (Pattern markerPattern : this.knownMarkerNames) {
            if (!markerPattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean similarStack(class_1799 firstItem, class_1799 secondItem) {
        if (!firstItem.method_7909().equals(secondItem.method_7909())) {
            return false;
        }
        if (firstItem.field_8031 != secondItem.field_8031 || firstItem.field_8031 != 1) {
            return false;
        }
        return firstItem.method_7919() == secondItem.method_7919();
    }

    private boolean isWildcardItem(class_1799 itemStack) {
        return WILDCARD_ITEMS.contains(itemStack.method_7909());
    }

    private boolean isLoreSoftMatching(class_1799 firstItem, class_1799 secondItem) {
        int secondLinesLen;
        LinkedList<StyledText> secondLoreLines;
        LinkedList<StyledText> firstLoreLines = LoreUtils.getLore(firstItem);
        if (Objects.equals(firstLoreLines, secondLoreLines = LoreUtils.getLore(secondItem))) {
            return true;
        }
        int firstLinesLen = firstLoreLines.size();
        if (Math.abs(firstLinesLen - (secondLinesLen = secondLoreLines.size())) > 3) {
            return false;
        }
        int linesToCheck = Math.min(firstLinesLen, secondLinesLen);
        if (linesToCheck < 3 && firstLinesLen != secondLinesLen) {
            return false;
        }
        for (int i = 0; i < linesToCheck; ++i) {
            StyledText secondLine;
            StyledText firstLine = (StyledText)firstLoreLines.get(i);
            if (firstLine.equals(secondLine = (StyledText)secondLoreLines.get(i))) continue;
            return false;
        }
        return true;
    }

    private ItemAnnotation calculateAnnotation(class_1799 itemStack, StyledText name) {
        long startTime = System.currentTimeMillis();
        StyledText simplified = this.simplifyName(name);
        ItemAnnotation annotation = null;
        for (ItemAnnotator annotator : this.annotators) {
            try {
                annotation = annotator.getAnnotation(itemStack, simplified);
                if (annotation == null) continue;
                break;
            }
            catch (Throwable t) {
                this.crashedAnnotators.add(annotator);
                String annotatorName = annotator.getClass().getSimpleName();
                WynntilsMod.reportCrash(CrashType.ANNOTATOR, annotatorName, annotator.getClass().getName(), "handling", t);
                WynntilsMod.warn("Problematic item:" + String.valueOf(itemStack));
                WynntilsMod.warn("Problematic item name:" + String.valueOf(StyledText.fromComponent(itemStack.method_7964())));
                WynntilsMod.warn("Problematic item tags:" + String.valueOf(itemStack.method_40133()));
                McUtils.sendErrorToClient("Not all items will be properly parsed.");
            }
        }
        for (ItemAnnotator annotator : this.crashedAnnotators) {
            this.annotators.remove(annotator);
        }
        this.crashedAnnotators.clear();
        if (annotation == null) {
            return null;
        }
        if (annotation instanceof WynnItem) {
            WynnItem wynnItem = (WynnItem)annotation;
            wynnItem.getData().store("itemstack", itemStack);
        }
        this.logProfilingData(startTime, annotation);
        return annotation;
    }

    private StyledText simplifyName(StyledText name) {
        for (Pattern pattern : this.simplifiablePatterns) {
            Matcher matcher = name.getMatcher(pattern);
            if (!matcher.matches()) continue;
            int start = matcher.start(1);
            int end = matcher.end(1);
            StyledText[] separate = name.partition(PartStyle.StyleType.DEFAULT, start, end);
            return separate[1];
        }
        return name;
    }

    private void annotate(class_1799 itemStack) {
        StyledText name = StyledText.fromComponent(itemStack.method_7964()).getNormalized();
        ItemAnnotation annotation = this.calculateAnnotation(itemStack, name);
        if (annotation == null) {
            return;
        }
        this.updateItem(itemStack, annotation, name);
    }

    private void logProfilingData(long startTime, ItemAnnotation annotation) {
        long endTime = System.currentTimeMillis();
        int timeSpent = (int)(endTime - startTime);
        int allTime = this.profilingTimes.getOrDefault(annotation.getClass(), 0);
        this.profilingTimes.put(annotation.getClass(), allTime + timeSpent);
        int allCount = this.profilingCounts.getOrDefault(annotation.getClass(), 0);
        this.profilingCounts.put(annotation.getClass(), allCount + 1);
    }

    public Map<Class<?>, Integer> getProfilingTimes() {
        return this.profilingTimes;
    }

    public Map<Class<?>, Integer> getProfilingCounts() {
        return this.profilingCounts;
    }

    public void resetProfiling() {
        this.profilingTimes.clear();
        this.profilingCounts.clear();
    }

    public List<ItemAnnotator> getAnnotators() {
        return Collections.unmodifiableList(this.annotators);
    }
}

