/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities;

import com.google.gson.JsonObject;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.net.ApiResponse;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.combat.ContentTrackerFeature;
import com.wynntils.handlers.scoreboard.ScoreboardPart;
import com.wynntils.mc.event.ContainerSetContentEvent;
import com.wynntils.mc.extension.EntityExtension;
import com.wynntils.models.activities.ActivityTrackerScoreboardPart;
import com.wynntils.models.activities.ContentBookQueries;
import com.wynntils.models.activities.DialogueHistoryQueries;
import com.wynntils.models.activities.beacons.ActivityBeaconKind;
import com.wynntils.models.activities.beacons.ActivityBeaconMarkerKind;
import com.wynntils.models.activities.caves.CaveInfo;
import com.wynntils.models.activities.event.ActivityTrackerUpdatedEvent;
import com.wynntils.models.activities.event.DialogueHistoryReloadedEvent;
import com.wynntils.models.activities.markers.ActivityMarkerProvider;
import com.wynntils.models.activities.quests.QuestInfo;
import com.wynntils.models.activities.quests.QuestModel;
import com.wynntils.models.activities.type.ActivityDifficulty;
import com.wynntils.models.activities.type.ActivityDistance;
import com.wynntils.models.activities.type.ActivityInfo;
import com.wynntils.models.activities.type.ActivityLength;
import com.wynntils.models.activities.type.ActivityRequirements;
import com.wynntils.models.activities.type.ActivityRewardType;
import com.wynntils.models.activities.type.ActivityStatus;
import com.wynntils.models.activities.type.ActivityTrackingState;
import com.wynntils.models.activities.type.ActivityType;
import com.wynntils.models.activities.type.WorldEventFastTravelStatus;
import com.wynntils.models.beacons.event.BeaconEvent;
import com.wynntils.models.beacons.event.BeaconMarkerEvent;
import com.wynntils.models.beacons.type.Beacon;
import com.wynntils.models.beacons.type.BeaconMarker;
import com.wynntils.models.beacons.type.BeaconMarkerKind;
import com.wynntils.models.character.event.CharacterUpdateEvent;
import com.wynntils.models.containers.containers.ContentBookContainer;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.models.profession.type.ProfessionType;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.screens.activities.ContentBookHolder;
import com.wynntils.screens.maps.MainMapScreen;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.StyledTextUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_3417;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class ActivityModel
extends Model {
    public static final String CONTENT_BOOK_TITLE = "\udaff\udfee\ue004";
    private static final String WIKI_APOSTROPHE = "&#039;";
    private static final String PLAYER_PROGRESS_ITEM_NAME = "All Player Progress";
    private static final Pattern LEVEL_REQ_PATTERN = Pattern.compile("^\u00a7(.).\u00c0?\u00a77(?: Recommended)? Combat Lv(?:\\. Min)?: (\\d+)$");
    private static final Pattern PROFESSION_REQ_PATTERN = Pattern.compile("^\u00a7(.).\u00c0?\u00a77 (\\w+)? Lv\\. Min: (\\d+)$");
    private static final Pattern QUEST_REQ_PATTERN = Pattern.compile("^\u00a7(.).\u00c0?\u00a77 Quest Req: (.+)$");
    private static final Pattern DISTANCE_PATTERN = Pattern.compile("^\udb00\udc0e\u00a77Distance: \u00a7.([\\w\\s]*)(?:\u00a78 \\((.+)\\))?$");
    private static final Pattern LENGTH_PATTERN = Pattern.compile("^\udb00\udc0e\u00a77Length: (\\w*)(?:\u00a78 \\((.+)\\))?$");
    private static final Pattern DIFFICULTY_PATTERN = Pattern.compile("^\udb00\udc0e\u00a77Difficulty: (\\w*)$");
    private static final Pattern REWARD_HEADER_PATTERN = Pattern.compile("^\udb00\udc0e\u00a7dRewards:$");
    private static final Pattern REWARD_PATTERN = Pattern.compile("^\u00a7d\udb00\udc04(- )?\u00a77\\+?(?<reward>.+)$");
    private static final Pattern TRACKING_PATTERN = Pattern.compile(".+\u00a7f\ue000 \u00a7#[a-f0-9]{8}\u00a7lClick To (Untrack|Track)");
    private static final Pattern REQUIRES_HERO_PLUS_PATTERN = Pattern.compile(".+\u00a77Requires \u00a7f\ue08a");
    private static final Pattern OVERALL_PROGRESS_PATTERN = Pattern.compile("^\\S*\u00a77(\\d+) of (\\d+) completed$");
    private static final Pattern WIKI_REDIRECT_PATTERN = Pattern.compile("#REDIRECT \\[\\[(?<redirectname>.+)\\]\\]");
    private static final ScoreboardPart TRACKER_SCOREBOARD_PART = new ActivityTrackerScoreboardPart();
    private static final ContentBookQueries CONTAINER_QUERIES = new ContentBookQueries();
    private static final DialogueHistoryQueries DIALOGUE_HISTORY_QUERIES = new DialogueHistoryQueries();
    public static final ActivityMarkerProvider ACTIVITY_MARKER_PROVIDER = new ActivityMarkerProvider();
    private TrackedActivity trackedActivity;
    private List<List<StyledText>> dialogueHistory = List.of();
    private CappedValue overallProgress = CappedValue.EMPTY;
    private boolean overallProgressOutdated = true;
    private String currentProgressCharacter = "";

    public ActivityModel(MarkerModel markerModel) {
        super(List.of(markerModel));
        Handlers.Scoreboard.addPart(TRACKER_SCOREBOARD_PART);
        Models.Marker.registerMarkerProvider(ACTIVITY_MARKER_PROVIDER);
        Handlers.WrappedScreen.registerWrappedScreen(new ContentBookHolder());
        for (ActivityBeaconKind activityBeaconKind : ActivityBeaconKind.values()) {
            Models.Beacon.registerBeacon(activityBeaconKind);
        }
        for (Enum enum_ : ActivityBeaconMarkerKind.values()) {
            Models.Beacon.registerBeaconMarker((BeaconMarkerKind)((Object)enum_));
        }
    }

    @SubscribeEvent
    public void onBeaconAdded(BeaconEvent.Added event) {
        Beacon beacon = event.getBeacon();
        if (!(beacon.beaconKind() instanceof ActivityBeaconKind)) {
            return;
        }
        ContentTrackerFeature feature = Managers.Feature.getFeatureInstance(ContentTrackerFeature.class);
        if (((Boolean)feature.hideOriginalMarker.get()).booleanValue() && feature.isEnabled()) {
            ((EntityExtension)event.getEntity()).setRendered(false);
        }
    }

    @SubscribeEvent
    public void onBeaconMarkerAdded(BeaconMarkerEvent.Added event) {
        BeaconMarker beaconMarker = event.getBeaconMarker();
        BeaconMarkerKind beaconMarkerKind = beaconMarker.beaconMarkerKind();
        if (!(beaconMarkerKind instanceof ActivityBeaconMarkerKind)) {
            return;
        }
        ActivityBeaconMarkerKind activityBeaconMarker = (ActivityBeaconMarkerKind)beaconMarkerKind;
        ContentTrackerFeature feature = Managers.Feature.getFeatureInstance(ContentTrackerFeature.class);
        if (feature.isEnabled()) {
            if (((Boolean)feature.hideOriginalMarker.get()).booleanValue()) {
                ((EntityExtension)event.getEntity()).setRendered(false);
            }
            if (((Boolean)feature.autoTrackCoordinates.get()).booleanValue()) {
                Location spawn = new Location(McUtils.mc().field_1687.method_43126());
                ACTIVITY_MARKER_PROVIDER.setSpawnLocation(activityBeaconMarker.getActivityType(), spawn);
                if (this.trackedActivity == null) {
                    return;
                }
                Location trackedLocation = this.getTrackedLocation();
                if (trackedLocation != null && !spawn.equals(trackedLocation)) {
                    ACTIVITY_MARKER_PROVIDER.setTrackedActivityLocation(activityBeaconMarker.getActivityType(), trackedLocation);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBeaconMarkerRemoved(BeaconMarkerEvent.Removed event) {
        BeaconMarker beaconMarker = event.getBeaconMarker();
        if (!(beaconMarker.beaconMarkerKind() instanceof ActivityBeaconMarkerKind)) {
            return;
        }
        ACTIVITY_MARKER_PROVIDER.setSpawnLocation(null, null);
        ACTIVITY_MARKER_PROVIDER.setTrackedActivityLocation(null, null);
    }

    @SubscribeEvent
    public void onContainerItemsSet(ContainerSetContentEvent.Pre event) {
        if (!(Models.Container.getCurrentContainer() instanceof ContentBookContainer)) {
            return;
        }
        for (class_1799 itemStack : event.getItems()) {
            if (!itemStack.method_7964().getString().equals(PLAYER_PROGRESS_ITEM_NAME) || !this.parseOverallProgress(LoreUtils.getLore(itemStack))) continue;
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldStateChanged(WorldStateEvent e) {
        this.resetTracker();
        this.overallProgressOutdated = true;
    }

    @SubscribeEvent
    public void onCharacterUpdated(CharacterUpdateEvent event) {
        if (Models.Character.getId().equals(this.currentProgressCharacter)) {
            this.overallProgressOutdated = false;
            return;
        }
        this.scanOverallProgress();
    }

    public ActivityInfo parseItem(String name, ActivityType type, class_1799 itemStack) {
        ActivityStatus status;
        String specialInfo;
        LinkedList<StyledText> lore = LoreUtils.getLore(itemStack);
        StyledText statusLine = (StyledText)lore.pop();
        StyledText[] statusLineParts = statusLine.split(" - ");
        if (type == ActivityType.WORLD_EVENT) {
            specialInfo = statusLine.getString();
            statusMessage = ((StyledText)lore.pop()).getString();
            status = ActivityStatus.fromWorldEvent(statusMessage);
        } else {
            if (statusLineParts.length == 1) {
                specialInfo = null;
                statusMessage = statusLineParts[0].getString();
            } else {
                specialInfo = statusLineParts[0].getString();
                statusMessage = statusLineParts[1].getString();
            }
            status = ActivityStatus.from(statusMessage);
        }
        if (status == null) {
            return null;
        }
        if (!((StyledText)lore.pop()).isBlank()) {
            return null;
        }
        Pair<Integer, Boolean> levelReq = Pair.of(0, true);
        ActivityDistance distance = null;
        String distanceInfo = null;
        ActivityLength length = null;
        String lengthInfo = null;
        ActivityDifficulty difficulty = null;
        ActivityTrackingState trackingState = ActivityTrackingState.UNTRACKABLE;
        ArrayList<Pair<Pair<ProfessionType, Integer>, Boolean>> professionLevels = new ArrayList<Pair<Pair<ProfessionType, Integer>, Boolean>>();
        ArrayList<Pair<String, Boolean>> quests = new ArrayList<Pair<String, Boolean>>();
        WorldEventFastTravelStatus worldEventFastTravelStatus = null;
        TreeMap<ActivityRewardType, List<StyledText>> rewards = new TreeMap<ActivityRewardType, List<StyledText>>();
        ArrayList<StyledText> descriptionLines = new ArrayList<StyledText>();
        ActivityRewardType previousRewardType = null;
        for (StyledText line : lore) {
            Matcher levelReqMatcher = line.getMatcher(LEVEL_REQ_PATTERN);
            if (levelReqMatcher.matches()) {
                boolean fulfilled = this.isFulfilled(levelReqMatcher);
                int level = Integer.parseInt(levelReqMatcher.group(2));
                levelReq = Pair.of(level, fulfilled);
                continue;
            }
            Matcher professionReqMatcher = line.getMatcher(PROFESSION_REQ_PATTERN);
            if (professionReqMatcher.matches()) {
                boolean fulfilled = this.isFulfilled(professionReqMatcher);
                ProfessionType profession = ProfessionType.fromString(professionReqMatcher.group(2));
                int level = Integer.parseInt(professionReqMatcher.group(3));
                professionLevels.add(Pair.of(Pair.of(profession, level), fulfilled));
                continue;
            }
            Matcher questReqMatcher = line.getMatcher(QUEST_REQ_PATTERN);
            if (questReqMatcher.matches()) {
                boolean fulfilled = this.isFulfilled(questReqMatcher);
                String quest = questReqMatcher.group(2);
                quests.add(Pair.of(quest, fulfilled));
                continue;
            }
            Matcher distanceMatcher = line.getMatcher(DISTANCE_PATTERN);
            if (distanceMatcher.matches()) {
                distance = ActivityDistance.from(distanceMatcher.group(1));
                distanceInfo = distanceMatcher.group(2);
                continue;
            }
            Matcher lengthMatcher = line.getMatcher(LENGTH_PATTERN);
            if (lengthMatcher.matches()) {
                length = ActivityLength.from(lengthMatcher.group(1));
                lengthInfo = lengthMatcher.group(2);
                continue;
            }
            Matcher difficultyMatcher = line.getMatcher(DIFFICULTY_PATTERN);
            if (difficultyMatcher.matches()) {
                difficulty = ActivityDifficulty.from(difficultyMatcher.group(1));
                continue;
            }
            Matcher rewardHeaderMatcher = line.getMatcher(REWARD_HEADER_PATTERN);
            if (rewardHeaderMatcher.matches()) continue;
            Matcher rewardMatcher = line.getMatcher(REWARD_PATTERN);
            if (rewardMatcher.matches()) {
                ActivityRewardType rewardType = ActivityRewardType.matchRewardType(rewardMatcher.group("reward"));
                List existingRewards = rewards.getOrDefault((Object)rewardType, new ArrayList());
                existingRewards.add(StyledText.fromString(rewardMatcher.group("reward").trim() + String.valueOf(class_124.field_1070)));
                rewards.put(rewardType, existingRewards);
                previousRewardType = rewardType;
                continue;
            }
            Matcher trackingMatcher = line.getMatcher(TRACKING_PATTERN);
            if (trackingMatcher.matches()) {
                trackingState = trackingMatcher.group(1).equals("Track") ? ActivityTrackingState.TRACKABLE : ActivityTrackingState.TRACKED;
                continue;
            }
            if (line.trim().isEmpty()) {
                previousRewardType = null;
                continue;
            }
            if (previousRewardType != null) {
                StyledText existingReward = (StyledText)((List)rewards.get((Object)previousRewardType)).getLast();
                existingReward = existingReward.append(" " + line.getStringWithoutFormatting().trim() + String.valueOf(class_124.field_1070));
                ((List)rewards.get((Object)previousRewardType)).set(((List)rewards.get((Object)previousRewardType)).size() - 1, existingReward);
                continue;
            }
            if (type == ActivityType.WORLD_EVENT && worldEventFastTravelStatus == null && (worldEventFastTravelStatus = WorldEventFastTravelStatus.fromLine(line)) != null || worldEventFastTravelStatus == WorldEventFastTravelStatus.UNAVAILABLE && line.matches(REQUIRES_HERO_PLUS_PATTERN)) continue;
            descriptionLines.add(line);
        }
        StyledText description = StyledTextUtils.joinLines(descriptionLines).getNormalized();
        if (description.isEmpty()) {
            description = null;
        }
        ActivityRequirements requirements = new ActivityRequirements(levelReq, professionLevels, quests);
        return new ActivityInfo(type, name, status, Optional.ofNullable(specialInfo), Optional.ofNullable(description), Optional.ofNullable(length), Optional.ofNullable(lengthInfo), Optional.ofNullable(distance), Optional.ofNullable(distanceInfo), Optional.ofNullable(difficulty), Optional.ofNullable(worldEventFastTravelStatus), requirements, rewards, trackingState);
    }

    public void openActivityOnWiki(ActivityInfo activityInfo) {
        switch (activityInfo.type()) {
            case QUEST: 
            case STORYLINE_QUEST: {
                this.openQuestOnWiki(activityInfo);
                break;
            }
            case MINI_QUEST: {
                this.openMiniQuestOnWiki(activityInfo);
                break;
            }
            default: {
                Managers.Net.openLink(UrlId.LINK_WIKI_LOOKUP, Map.of("title", activityInfo.name().replace(" ", "_")));
            }
        }
    }

    private void openQuestOnWiki(ActivityInfo activityInfo) {
        ApiResponse apiResponse = Managers.Net.callApi(UrlId.API_WIKI_QUEST_PAGE_QUERY, Map.of("name", activityInfo.name()));
        apiResponse.handleJsonArray(json -> {
            String pageTitle = json.get(0).getAsJsonObject().get("_pageTitle").getAsString().replace(WIKI_APOSTROPHE, "'");
            Managers.Net.openLink(UrlId.LINK_WIKI_LOOKUP, Map.of("title", pageTitle));
        });
    }

    private void openMiniQuestOnWiki(ActivityInfo activityInfo) {
        String type = activityInfo.name().split(" ")[0];
        String wikiName = "Quests#" + type + "ing_Posts";
        Managers.Net.openLink(UrlId.LINK_WIKI_LOOKUP, Map.of("title", wikiName));
    }

    public void openMapOnActivity(ActivityInfo activityInfo) {
        switch (activityInfo.type()) {
            case QUEST: 
            case STORYLINE_QUEST: 
            case MINI_QUEST: {
                this.openMapOnQuest(activityInfo);
                break;
            }
            case CAVE: {
                this.openMapOnCave(activityInfo);
                break;
            }
            case WORLD_EVENT: {
                return;
            }
            default: {
                this.locateActivity(activityInfo, ActivityOpenAction.MAP);
            }
        }
    }

    private void openMapOnQuest(ActivityInfo activityInfo) {
        QuestInfo questInfo = QuestModel.getQuestInfoFromActivity(activityInfo);
        if (questInfo.nextLocation().isPresent()) {
            McUtils.player().method_7346();
            McUtils.mc().method_1507(MainMapScreen.create(questInfo.nextLocation().get().x(), questInfo.nextLocation().get().z()));
        }
    }

    private void openMapOnCave(ActivityInfo activityInfo) {
        CaveInfo caveInfo = Models.Cave.getCaveInfoFromActivity(activityInfo);
        if (caveInfo.getNextLocation().isPresent()) {
            McUtils.player().method_7346();
            McUtils.mc().method_1507(MainMapScreen.create(caveInfo.getNextLocation().get().x(), caveInfo.getNextLocation().get().z()));
        }
    }

    public void placeCompassOnActivity(ActivityInfo activityInfo) {
        switch (activityInfo.type()) {
            case QUEST: 
            case STORYLINE_QUEST: 
            case MINI_QUEST: 
            case WORLD_EVENT: {
                return;
            }
        }
        this.locateActivity(activityInfo, ActivityOpenAction.COMPASS);
    }

    private void locateActivity(ActivityInfo activityInfo, ActivityOpenAction openAction) {
        this.checkWikiForActivity(activityInfo.name(), activityInfo, openAction);
    }

    private void checkWikiForActivity(String activityName, ActivityInfo activityInfo, ActivityOpenAction openAction) {
        ApiResponse apiResponse = Managers.Net.callApi(UrlId.API_WIKI_DISCOVERY_QUERY, Map.of("name", activityName));
        apiResponse.handleJsonObject(json -> this.handleActivityJsonResponse((JsonObject)json, activityInfo, openAction));
    }

    private void handleActivityJsonResponse(JsonObject json, ActivityInfo activityInfo, ActivityOpenAction openAction) {
        int z;
        int x;
        if (json.has("error")) {
            McUtils.sendErrorToClient("Unable to find activity coordinates. (Wiki page not found)");
            return;
        }
        String wikiText = json.get("parse").getAsJsonObject().get("wikitext").getAsJsonObject().get("*").getAsString();
        Matcher redirectMatcher = WIKI_REDIRECT_PATTERN.matcher(wikiText);
        if (redirectMatcher.matches()) {
            this.checkWikiForActivity(redirectMatcher.group("redirectname"), activityInfo, openAction);
            return;
        }
        wikiText = wikiText.replace(" ", "").replace("\n", "");
        String xLocation = wikiText.substring(wikiText.indexOf("xcoordinate="));
        String zLocation = wikiText.substring(wikiText.indexOf("zcoordinate="));
        int xEnd = Math.min(xLocation.indexOf(124), xLocation.indexOf("}}"));
        int zEnd = Math.min(zLocation.indexOf(124), zLocation.indexOf("}}"));
        try {
            x = Integer.parseInt(xLocation.substring(12, xEnd));
            z = Integer.parseInt(zLocation.substring(12, zEnd));
        }
        catch (NumberFormatException e) {
            McUtils.sendErrorToClient("Unable to find discovery coordinates. (Wiki template not located)");
            return;
        }
        if (x == 0 && z == 0) {
            McUtils.sendErrorToClient("Unable to find discovery coordinates. (Wiki coordinates not located)");
            return;
        }
        switch (openAction.ordinal()) {
            case 0: {
                Managers.TickScheduler.scheduleNextTick(() -> {
                    McUtils.player().method_7346();
                    McUtils.mc().method_1507(MainMapScreen.create(x, z));
                });
                break;
            }
            case 1: {
                McUtils.playSoundUI(class_3417.field_14627);
                MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(new Location(x, 0, z), activityInfo.name());
            }
        }
    }

    private boolean isFulfilled(Matcher colorCodeMatcher) {
        return colorCodeMatcher.group(1).charAt(0) == class_124.field_1060.method_36145();
    }

    public CappedValue getOverallProgress() {
        return this.overallProgress;
    }

    public String getTrackedName() {
        if (this.trackedActivity == null) {
            return "";
        }
        return this.trackedActivity.trackedName();
    }

    public ActivityType getTrackedType() {
        if (this.trackedActivity == null) {
            return null;
        }
        return this.trackedActivity.trackedType();
    }

    public StyledText getTrackedTask() {
        if (this.trackedActivity == null) {
            return StyledText.EMPTY;
        }
        return this.trackedActivity.trackedTask();
    }

    public QuestInfo getTrackedQuestInfo() {
        if (this.trackedActivity == null) {
            return null;
        }
        return Models.Quest.getQuestInfoFromName(this.trackedActivity.trackedName()).orElse(null);
    }

    public CaveInfo getTrackedCaveInfo() {
        if (this.trackedActivity == null) {
            return null;
        }
        return Models.Cave.getCaveInfoFromName(this.trackedActivity.trackedName()).orElse(null);
    }

    void updateTracker(String name, String type, StyledText nextTask) {
        ActivityType trackedType = ActivityType.from(type);
        this.trackedActivity = new TrackedActivity(name, trackedType, nextTask);
        WynntilsMod.postEvent(new ActivityTrackerUpdatedEvent(this.trackedActivity.trackedType(), this.trackedActivity.trackedName(), this.trackedActivity.trackedTask()));
    }

    void resetTracker() {
        this.trackedActivity = null;
        ACTIVITY_MARKER_PROVIDER.setTrackedActivityLocation(null, null);
    }

    public void scanContentBook(ActivityType activityType, BiConsumer<List<ActivityInfo>, List<StyledText>> processResult) {
        CONTAINER_QUERIES.queryContentBook(activityType, processResult, true, false);
    }

    public void startTracking(String name, ActivityType activityType) {
        CONTAINER_QUERIES.toggleTracking(name, activityType);
    }

    public void stopTracking() {
        CONTAINER_QUERIES.toggleTracking(this.trackedActivity.trackedName(), this.trackedActivity.trackedType());
    }

    public boolean isTracking() {
        return this.trackedActivity != null;
    }

    public List<List<StyledText>> getDialogueHistory() {
        return this.dialogueHistory;
    }

    public void rescanDialogueHistory() {
        DIALOGUE_HISTORY_QUERIES.scanDialogueHistory();
    }

    private void scanOverallProgress() {
        if (!this.overallProgressOutdated) {
            return;
        }
        this.overallProgressOutdated = false;
        CONTAINER_QUERIES.queryContentBook(ActivityType.RECOMMENDED, (ignored, progress) -> {
            if (this.parseOverallProgress((List<StyledText>)progress)) {
                return;
            }
        }, false, true);
    }

    private boolean parseOverallProgress(List<StyledText> progress) {
        for (StyledText line : progress) {
            Matcher m = line.getMatcher(OVERALL_PROGRESS_PATTERN);
            if (!m.matches()) continue;
            int completed = Integer.parseInt(m.group(1));
            int total = Integer.parseInt(m.group(2));
            this.overallProgress = new CappedValue(completed, total);
            this.currentProgressCharacter = Models.Character.getId();
            return true;
        }
        return false;
    }

    void setDialogueHistory(List<List<StyledText>> newDialogueHistory) {
        this.dialogueHistory = newDialogueHistory;
        WynntilsMod.postEvent(new DialogueHistoryReloadedEvent());
    }

    private Location getTrackedLocation() {
        return StyledTextUtils.extractLocation(this.trackedActivity.trackedTask()).orElse(null);
    }

    private record TrackedActivity(String trackedName, ActivityType trackedType, StyledText trackedTask) {
    }

    public static enum ActivityOpenAction {
        MAP,
        COMPASS;

    }
}

