/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities.type;

import com.wynntils.utils.render.Texture;
import java.util.List;
import java.util.regex.Pattern;

public enum ActivityRewardType {
    XP(List.of(Pattern.compile("\\d+(?: .+)? XP")), Texture.XP_REWARD),
    EMERALDS(List.of(Pattern.compile("\\d+ Emeralds"), Pattern.compile("Various Emeralds")), Texture.EMERALD_REWARD),
    ACCESS(List.of(Pattern.compile("Access to .+")), Texture.ACCESS_REWARD),
    ITEM(List.of(), Texture.ITEM_REWARD);

    private final List<Pattern> patterns;
    private final Texture texture;

    private ActivityRewardType(List<Pattern> patterns, Texture texture) {
        this.patterns = patterns;
        this.texture = texture;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public static ActivityRewardType matchRewardType(String rewardLine) {
        for (ActivityRewardType rewardType : ActivityRewardType.values()) {
            for (Pattern pattern : rewardType.patterns) {
                if (!pattern.matcher(rewardLine).matches()) continue;
                return rewardType;
            }
        }
        return ITEM;
    }
}

