/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.aspects;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.aspects.type.AspectInfo;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.wynnitem.AbstractItemInfoDeserializer;
import com.wynntils.models.wynnitem.type.ItemMaterial;
import com.wynntils.utils.type.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class AspectInfoRegistry {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(AspectInfo.class, (Object)new AspectInfoDeserializer()).create();
    private List<AspectInfo> aspectInfoRegistry = List.of();
    private Map<ClassType, Map<String, AspectInfo>> aspectInfoLookup = Map.of();

    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_STATIC_ASPECTS).handleJsonObject(this::handleAspects);
    }

    public AspectInfo getFromClassAndDisplayName(ClassType classType, String aspectName) {
        Map<String, AspectInfo> aspectInfoMap = this.aspectInfoLookup.get((Object)classType);
        if (aspectInfoMap == null) {
            WynntilsMod.warn("No aspect info found for class type: " + String.valueOf((Object)classType));
            return null;
        }
        return aspectInfoMap.get(aspectName);
    }

    public AspectInfo getFromDisplayName(String aspectName) {
        return Arrays.stream(ClassType.values()).map(classType -> this.getFromClassAndDisplayName((ClassType)((Object)classType), aspectName)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Stream<AspectInfo> getAllAspectInfos() {
        return this.aspectInfoRegistry.stream();
    }

    private void handleAspects(JsonObject json) {
        ArrayList<AspectInfo> registry = new ArrayList<AspectInfo>();
        HashMap<ClassType, Map<String, AspectInfo>> lookupMap = new HashMap<ClassType, Map<String, AspectInfo>>();
        for (Map.Entry classEntry : json.entrySet()) {
            ClassType classType = ClassType.fromName((String)classEntry.getKey());
            if (classType == null) {
                WynntilsMod.warn("Unknown aspect class type: " + (String)classEntry.getKey());
                continue;
            }
            HashMap<String, AspectInfo> classLookupMap = new HashMap<String, AspectInfo>();
            JsonObject classAspectsObject = ((JsonElement)classEntry.getValue()).getAsJsonObject();
            for (Map.Entry aspectEntry : classAspectsObject.entrySet()) {
                JsonObject aspectJsonObject = ((JsonElement)aspectEntry.getValue()).getAsJsonObject();
                AspectInfo aspectInfo = (AspectInfo)GSON.fromJson((JsonElement)aspectJsonObject, AspectInfo.class);
                registry.add(aspectInfo);
                classLookupMap.put(aspectInfo.name(), aspectInfo);
            }
            lookupMap.put(classType, classLookupMap);
        }
        this.aspectInfoRegistry = registry;
        this.aspectInfoLookup = lookupMap;
    }

    private static final class AspectInfoDeserializer
    extends AbstractItemInfoDeserializer<AspectInfo> {
        private AspectInfoDeserializer() {
        }

        public AspectInfo deserialize(JsonElement jsonElement, Type jsonType, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = jsonElement.getAsJsonObject();
            String name = json.get("name").getAsString();
            GearTier gearTier = GearTier.fromString(json.get("rarity").getAsString());
            ClassType classType = ClassType.fromName(json.get("requiredClass").getAsString());
            ItemMaterial itemMaterial = this.parseMaterial(json);
            ArrayList<Pair<Integer, List<StyledText>>> tiers = new ArrayList<Pair<Integer, List<StyledText>>>();
            JsonObject jsonTiers = json.getAsJsonObject("tiers");
            for (Map.Entry entry : jsonTiers.entrySet()) {
                JsonObject tier = ((JsonElement)entry.getValue()).getAsJsonObject();
                int threshold = tier.get("threshold").getAsInt();
                ArrayList<StyledText> description = new ArrayList<StyledText>();
                for (JsonElement element : tier.get("description").getAsJsonArray()) {
                    description.add(StyledText.fromJson(element.getAsJsonArray()));
                }
                tiers.add(Pair.of(threshold, description));
            }
            return new AspectInfo(name, gearTier, classType, tiers, itemMaterial);
        }
    }
}

