/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.bonustotems;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.handlers.labels.event.LabelIdentifiedEvent;
import com.wynntils.handlers.labels.type.LabelInfo;
import com.wynntils.mc.event.RemoveEntitiesEvent;
import com.wynntils.models.bonustotems.BonusTotem;
import com.wynntils.models.bonustotems.label.BonusTotemLabelInfo;
import com.wynntils.models.bonustotems.label.BonusTotemLabelParser;
import com.wynntils.models.bonustotems.type.BonusTotemType;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.utils.mc.PosUtils;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.neoforged.bus.api.SubscribeEvent;

public final class BonusTotemModel
extends Model {
    private final Map<BonusTotemType, Map<Integer, BonusTotem>> bonusTotems = new TreeMap<BonusTotemType, Map<Integer, BonusTotem>>();

    public BonusTotemModel() {
        super(List.of());
        Handlers.Label.registerParser(new BonusTotemLabelParser());
    }

    @SubscribeEvent
    public void onLabelIdentified(LabelIdentifiedEvent event) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        LabelInfo labelInfo = event.getLabelInfo();
        if (!(labelInfo instanceof BonusTotemLabelInfo)) {
            return;
        }
        BonusTotemLabelInfo bonusTotemLabelInfo = (BonusTotemLabelInfo)labelInfo;
        Map bonusTotemMap = this.bonusTotems.getOrDefault((Object)bonusTotemLabelInfo.getBonusTotemType(), new LinkedHashMap());
        bonusTotemMap.putIfAbsent(event.getLabelInfo().getEntity().method_5628(), new BonusTotem(bonusTotemLabelInfo.getBonusTotemType(), PosUtils.newPosition(event.getLabelInfo().getEntity()), bonusTotemLabelInfo.getUser()));
        ((BonusTotem)bonusTotemMap.get(event.getLabelInfo().getEntity().method_5628())).setTimerString(bonusTotemLabelInfo.getTimerString());
        this.bonusTotems.put(bonusTotemLabelInfo.getBonusTotemType(), bonusTotemMap);
    }

    @SubscribeEvent
    public void onTotemDestroy(RemoveEntitiesEvent e) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        e.getEntityIds().forEach(entity -> this.bonusTotems.values().forEach(map -> map.remove(entity)));
    }

    @SubscribeEvent
    public void onWorldChange(WorldStateEvent e) {
        this.bonusTotems.clear();
    }

    public List<BonusTotem> getBonusTotemsByType(BonusTotemType type) {
        return ((Map)this.bonusTotems.getOrDefault((Object)type, new LinkedHashMap())).values().stream().sorted(Comparator.comparing(BonusTotem::getOwner)).toList();
    }

    public BonusTotem getBonusTotem(BonusTotemType type, int index) {
        if (index < 0 || index >= ((Map)this.bonusTotems.getOrDefault((Object)type, new LinkedHashMap())).size()) {
            return null;
        }
        return this.getBonusTotemsByType(type).get(index);
    }
}

