/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.character.actionbar.matchers;

import com.wynntils.core.WynntilsMod;
import com.wynntils.handlers.actionbar.ActionBarSegment;
import com.wynntils.handlers.actionbar.ActionBarSegmentMatcher;
import com.wynntils.models.character.actionbar.segments.CharacterSelectionLevelSegment;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharacterSelectionLevelSegmentMatcher
implements ActionBarSegmentMatcher {
    private static final char POSITIVE_SPACE_HIGH_SURROGATE = '\udb00';
    private static final char NEGATIVE_SPACE_HIGH_SURROGATE = '\udaff';
    private static final String SEPARATOR = "\udaff\udffe";
    private static final char LEVEL_CHAR_START = '\ue030';
    private static final char LEVEL_CHAR_END = '\ue039';
    private static final Pattern CHARACTER_LEVEL_PATTERN = Pattern.compile(".(?<level>([\ue030-\ue039]\udaff\udffe?){1,6}).");

    @Override
    public ActionBarSegment parse(String actionBar) {
        boolean validEnd;
        Matcher matcher = CHARACTER_LEVEL_PATTERN.matcher(actionBar);
        if (!matcher.find()) {
            return null;
        }
        String segmentText = matcher.group();
        char startChar = segmentText.charAt(0);
        char endChar = segmentText.charAt(segmentText.length() - 2);
        boolean validStart = startChar == '\udaff';
        boolean bl = validEnd = endChar == '\udb00';
        if (!validStart || !validEnd) {
            return null;
        }
        int level = this.parseLevel(matcher.group("level"));
        return new CharacterSelectionLevelSegment(matcher.group(), level);
    }

    private int parseLevel(String levelText) {
        try {
            levelText = levelText.replace(SEPARATOR, "");
            StringBuilder levelBuilder = new StringBuilder();
            for (char current : levelText.toCharArray()) {
                if (current >= '\ue030' && current <= '\ue039') {
                    levelBuilder.append(current - 57392);
                    continue;
                }
                WynntilsMod.warn("Found unexpected character in character selection level segment: " + current);
            }
            return Integer.parseInt(levelBuilder.toString());
        }
        catch (NumberFormatException e) {
            WynntilsMod.warn("Failed to parse character selection level from segment: " + levelText);
            return 0;
        }
    }
}

