/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.containers;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ChestMenuQuickMoveEvent;
import com.wynntils.mc.event.ContainerSetSlotEvent;
import com.wynntils.mc.event.PlayerInteractEvent;
import com.wynntils.mc.event.ScreenClosedEvent;
import com.wynntils.mc.event.ScreenInitEvent;
import com.wynntils.mc.event.ScreenOpenedEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.reward.LootChestContainer;
import com.wynntils.models.containers.containers.reward.RewardContainer;
import com.wynntils.models.containers.event.ValuableFoundEvent;
import com.wynntils.models.containers.type.LootChestTier;
import com.wynntils.models.containers.type.MythicFind;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.items.items.game.EmeraldItem;
import com.wynntils.models.items.items.game.EmeraldPouchItem;
import com.wynntils.models.items.items.game.GearBoxItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.type.RangedValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_437;
import net.neoforged.bus.api.SubscribeEvent;

public final class LootChestModel
extends Model {
    public static final int LOOT_CHEST_ITEM_COUNT = 27;
    private static final int[] HIGH_TIER_EMERALD_POUCHES = new int[]{7, 8, 9, 10};
    @Persisted
    private final Storage<List<MythicFind>> mythicFinds = new Storage(new ArrayList());
    @Persisted
    private final Storage<Integer> openedChestCount = new Storage<Integer>(0);
    @Persisted
    private final Storage<Integer> dryCount = new Storage<Integer>(0);
    @Persisted
    private final Storage<Integer> dryBoxes = new Storage<Integer>(0);
    @Persisted
    private final Storage<Integer> dryEmeralds = new Storage<Integer>(0);
    @Persisted
    private final Storage<Map<Integer, Integer>> dryEmeraldPouchCount = new Storage(new TreeMap());
    @Persisted
    private final Storage<Map<GearTier, Integer>> dryItemTiers = new Storage(new EnumMap(GearTier.class));
    private class_2338 lastChestPos;
    private int nextExpectedLootContainerId = -2;
    private final List<LootChestTier> sessionChests = new ArrayList<LootChestTier>();

    public LootChestModel() {
        super(List.of());
    }

    public int getDryCount() {
        return (Integer)this.dryCount.get();
    }

    public int getDryBoxes() {
        return (Integer)this.dryBoxes.get();
    }

    public int getDryPouchCount(int tier) {
        return ((Map)this.dryEmeraldPouchCount.get()).getOrDefault(tier, 0);
    }

    public int getOpenedChestCount() {
        return (Integer)this.openedChestCount.get();
    }

    public List<MythicFind> getMythicFinds() {
        return Collections.unmodifiableList((List)this.mythicFinds.get());
    }

    @SubscribeEvent
    public void onQuickMove(ChestMenuQuickMoveEvent event) {
        if (event.getContainerId() == this.nextExpectedLootContainerId) {
            this.nextExpectedLootContainerId = -2;
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.InteractAt event) {
        class_1297 entity = event.getEntityHitResult().method_17782();
        if (entity != null && entity.method_5864() == class_1299.field_6069) {
            this.lastChestPos = entity.method_24515();
        }
    }

    @SubscribeEvent
    public void onScreenInit(ScreenInitEvent.Pre e) {
        Container container = Models.Container.getCurrentContainer();
        if (container instanceof RewardContainer) {
            RewardContainer rewardContainer = (RewardContainer)container;
            this.nextExpectedLootContainerId = rewardContainer.getContainerId();
            this.openedChestCount.store((Integer)this.openedChestCount.get() + 1);
            this.dryCount.store((Integer)this.dryCount.get() + 1);
            Map pouchCount = (Map)this.dryEmeraldPouchCount.get();
            for (int tier : HIGH_TIER_EMERALD_POUCHES) {
                int currentCount = pouchCount.getOrDefault(tier, 0);
                pouchCount.put(tier, currentCount + 1);
            }
            this.dryEmeraldPouchCount.store(pouchCount);
            this.dryEmeraldPouchCount.touched();
        } else {
            this.lastChestPos = null;
        }
    }

    @SubscribeEvent
    public void onScreenClose(ScreenClosedEvent.Post e) {
        this.nextExpectedLootContainerId = -2;
    }

    @SubscribeEvent
    public void onSetSlot(ContainerSetSlotEvent.Post event) {
        EmeraldPouchItem emeraldPouch;
        if (event.getContainerId() != this.nextExpectedLootContainerId) {
            return;
        }
        if (event.getSlot() >= 27) {
            return;
        }
        class_1799 itemStack = event.getItemStack();
        this.processItemFind(itemStack);
        Optional<GearBoxItem> gearBoxItem = Models.Item.asWynnItem(itemStack, GearBoxItem.class);
        if (gearBoxItem.isPresent()) {
            GearBoxItem gearBox = gearBoxItem.get();
            if (gearBox.getGearTier() == GearTier.MYTHIC) {
                WynntilsMod.postEvent(new ValuableFoundEvent(itemStack, ValuableFoundEvent.ItemSource.LOOT_CHEST));
                if (gearBox.getGearType() != GearType.MASTERY_TOME) {
                    this.storeMythicFind(itemStack, gearBox.getLevelRange());
                    this.resetNormalDryStatistics();
                }
            }
            return;
        }
        Optional<EmeraldPouchItem> emeraldPouchItem = Models.Item.asWynnItem(itemStack, EmeraldPouchItem.class);
        if (emeraldPouchItem.isPresent() && (emeraldPouch = emeraldPouchItem.get()).getTier() >= 7) {
            WynntilsMod.postEvent(new ValuableFoundEvent(itemStack, ValuableFoundEvent.ItemSource.LOOT_CHEST));
            Map pouchCount = (Map)this.dryEmeraldPouchCount.get();
            pouchCount.put(emeraldPouch.getTier(), 0);
            this.dryEmeraldPouchCount.store(pouchCount);
            this.dryEmeraldPouchCount.touched();
        }
    }

    @SubscribeEvent
    public void onScreenOpened(ScreenOpenedEvent.Post event) {
        LootChestTier tier;
        if (Models.Container.getCurrentContainer() instanceof LootChestContainer && (tier = this.getChestType(event.getScreen())) != null) {
            WynntilsMod.info("Found Loot Chest with tier: " + tier.getWaypointTier());
            this.sessionChests.add(tier);
        }
    }

    public LootChestTier getChestType(class_437 screen) {
        return LootChestTier.fromTitle(screen);
    }

    public int getLootChestOpenedThisSession(int tier, boolean exact) {
        return (int)this.sessionChests.stream().filter(lootChestTier -> exact ? lootChestTier.getWaypointTier() == tier : lootChestTier.getWaypointTier() >= tier).count();
    }

    private void processItemFind(class_1799 itemStack) {
        Optional<EmeraldItem> emeraldOptional = Models.Item.asWynnItem(itemStack, EmeraldItem.class);
        if (emeraldOptional.isPresent()) {
            this.dryEmeralds.store((Integer)this.dryEmeralds.get() + emeraldOptional.get().getEmeraldValue());
            return;
        }
        Optional<GearBoxItem> gearBoxOptional = Models.Item.asWynnItem(itemStack, GearBoxItem.class);
        if (gearBoxOptional.isPresent()) {
            GearTier gearBoxTier = gearBoxOptional.get().getGearTier();
            if (gearBoxTier == GearTier.MYTHIC) {
                return;
            }
            this.dryBoxes.store((Integer)this.dryBoxes.get() + 1);
            ((Map)this.dryItemTiers.get()).merge(gearBoxTier, 1, Integer::sum);
            this.dryItemTiers.touched();
            return;
        }
        Optional<GearItem> gearOptional = Models.Item.asWynnItem(itemStack, GearItem.class);
        if (gearOptional.isPresent()) {
            GearTier gearTier = gearOptional.get().getGearTier();
            ((Map)this.dryItemTiers.get()).merge(gearTier, 1, Integer::sum);
            this.dryItemTiers.touched();
            return;
        }
    }

    private void storeMythicFind(class_1799 itemStack, RangedValue levelRange) {
        Location chestLocation = new Location(this.lastChestPos == null ? McUtils.player().method_24515() : this.lastChestPos);
        ((List)this.mythicFinds.get()).add(new MythicFind(StyledText.fromComponent(itemStack.method_7964()).getStringWithoutFormatting(), levelRange, (Integer)this.openedChestCount.get(), (Integer)this.dryCount.get(), (Integer)this.dryBoxes.get(), (Integer)this.dryEmeralds.get(), (Map)this.dryItemTiers.get(), chestLocation, System.currentTimeMillis()));
        this.mythicFinds.touched();
    }

    private void resetNormalDryStatistics() {
        this.dryBoxes.store(0);
        this.dryCount.store(0);
        this.dryEmeralds.store(0);
        this.dryItemTiers.store(new EnumMap(GearTier.class));
    }
}

