/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.elements.type;

import com.wynntils.utils.StringUtils;
import net.minecraft.class_124;

public enum Element {
    EARTH("\ue001", class_124.field_1077, 0),
    THUNDER("\ue003", class_124.field_1054, 1),
    WATER("\ue004", class_124.field_1075, 2),
    FIRE("\ue002", class_124.field_1061, 3),
    AIR("\ue000", class_124.field_1068, 4);

    private final String symbol;
    private final class_124 colorCode;
    private final String displayName;
    private final int encodingId;

    private Element(String symbol, class_124 colorCode, int encodingId) {
        this.symbol = symbol;
        this.colorCode = colorCode;
        this.encodingId = encodingId;
        this.displayName = StringUtils.capitalized(this.name());
    }

    public static Element fromSymbol(String symbol) {
        for (Element element : Element.values()) {
            if (!element.symbol.equals(symbol)) continue;
            return element;
        }
        return null;
    }

    public static Element fromEncodingId(int encodingId) {
        for (Element element : Element.values()) {
            if (element.encodingId != encodingId) continue;
            return element;
        }
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public class_124 getColorCode() {
        return this.colorCode;
    }

    public int getEncodingId() {
        return this.encodingId;
    }
}

