/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.elements.type;

import com.wynntils.models.elements.type.Element;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CustomColor;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1802;

public enum Powder {
    EARTH(Element.EARTH, class_1802.field_8131, class_1802.field_8408, class_124.field_1077, class_124.field_1060, "Quake"),
    THUNDER(Element.THUNDER, class_1802.field_8192, class_1802.field_8492, class_124.field_1054, class_124.field_1065, "Chain Lightning"),
    WATER(Element.WATER, class_1802.field_8273, class_1802.field_8632, class_124.field_1075, class_124.field_1062, "Curse"),
    FIRE(Element.FIRE, class_1802.field_8330, class_1802.field_8264, class_124.field_1061, class_124.field_1079, "Courage"),
    AIR(Element.AIR, class_1802.field_8298, class_1802.field_8851, class_124.field_1068, class_124.field_1080, "Wind Prison");

    private final Element element;
    private final class_1792 lowTierItem;
    private final class_1792 highTierItem;
    private final class_124 lightColor;
    private final class_124 darkColor;
    private final String specialName;

    private Powder(Element element, class_1792 lowTierItem, class_1792 highTierItem, class_124 lightColor, class_124 darkColor, String specialName) {
        this.element = element;
        this.lowTierItem = lowTierItem;
        this.highTierItem = highTierItem;
        this.lightColor = lightColor;
        this.darkColor = darkColor;
        this.specialName = specialName;
    }

    public static Powder fromElement(Element element) {
        for (Powder powder : Powder.values()) {
            if (powder.element != element) continue;
            return powder;
        }
        return null;
    }

    public static Powder getFromSymbol(String symbol) {
        Element element = Element.fromSymbol(symbol);
        return Powder.fromElement(element);
    }

    public Element getElement() {
        return this.element;
    }

    public char getSymbol() {
        return this.element.getSymbol().charAt(0);
    }

    public CustomColor getColor() {
        return CustomColor.fromInt(this.lightColor.method_532()).withAlpha(255);
    }

    public class_1792 getLowTierItem() {
        return this.lowTierItem;
    }

    public class_1792 getHighTierItem() {
        return this.highTierItem;
    }

    public class_124 getLightColor() {
        return this.lightColor;
    }

    public class_124 getDarkColor() {
        return this.darkColor;
    }

    public String getSpecialName() {
        return this.specialName;
    }

    public String getName() {
        return StringUtils.capitalizeFirst(this.name().toLowerCase(Locale.ROOT));
    }
}

