/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.gear;

import com.google.gson.JsonObject;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.models.gear.GearInfoRegistry;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.GearInstance;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.items.items.game.GearBoxItem;
import com.wynntils.models.items.items.game.UnknownGearItem;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.models.wynnitem.parsing.CraftedItemParseResults;
import com.wynntils.models.wynnitem.parsing.WynnItemParseResult;
import com.wynntils.models.wynnitem.parsing.WynnItemParser;
import com.wynntils.models.wynnitem.type.ItemObtainInfo;
import com.wynntils.models.wynnitem.type.ItemObtainType;
import com.wynntils.utils.type.CappedValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_1799;

public final class GearModel
extends Model {
    public static final Pattern GEAR_PATTERN = Pattern.compile("^(?:(?<unidrarity>\u00a7[5abcdef])(?<unidentified>Unidentified ))?(?:\u00a7f\u2b21 )?(?<idrarity>\u00a7[5abcdef])?(?:Shiny )?(?<name>.+)$");
    private final GearInfoRegistry gearInfoRegistry = new GearInfoRegistry();
    private final Map<GearBoxItem, List<GearInfo>> possibilitiesCache = new HashMap<GearBoxItem, List<GearInfo>>();

    public GearModel() {
        super(List.of());
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        this.gearInfoRegistry.registerDownloads(registry);
    }

    public List<GearInfo> getPossibleGears(GearBoxItem gearBoxItem) {
        List<GearInfo> possibilities = this.possibilitiesCache.get(gearBoxItem);
        if (possibilities != null) {
            return possibilities;
        }
        List<GearInfo> possibleGear = this.getAllGearInfos().filter(gear -> gear.type() == gearBoxItem.getGearType() && gear.tier() == gearBoxItem.getGearTier() && this.canBeGearBox((GearInfo)gear) && gearBoxItem.getLevelRange().inRange(gear.requirements().level())).toList();
        this.possibilitiesCache.put(gearBoxItem, possibleGear);
        return possibleGear;
    }

    private boolean canBeGearBox(GearInfo gear) {
        return !gear.metaInfo().preIdentified() && gear.metaInfo().obtainInfo().stream().anyMatch(x -> ItemObtainType.BOXED_ITEMS.contains((Object)x.sourceType()));
    }

    public GearInstance parseInstance(GearInfo gearInfo, class_1799 itemStack) {
        WynnItemParseResult result = WynnItemParser.parseItemStack(itemStack, gearInfo.getVariableStatsMap());
        if (result.tier() != gearInfo.tier()) {
            WynntilsMod.warn("Tier for " + gearInfo.name() + " is reported as " + String.valueOf((Object)result.tier()));
        }
        return GearInstance.create(gearInfo, result.identifications(), result.powders(), result.rerolls(), result.shinyStat(), result.allRequirementsMet(), result.setInstance());
    }

    public GearInstance parseInstance(GearInfo gearInfo, JsonObject itemData) {
        WynnItemParseResult result = WynnItemParser.parseInternalRolls(gearInfo, itemData);
        return GearInstance.create(gearInfo, result.identifications(), result.powders(), result.rerolls(), Optional.empty(), false, Optional.empty());
    }

    public CraftedGearItem parseCraftedGearItem(class_1799 itemStack) {
        HashMap<StatType, StatPossibleValues> possibleValuesMap = new HashMap<StatType, StatPossibleValues>();
        WynnItemParseResult result = WynnItemParser.parseItemStack(itemStack, possibleValuesMap);
        CraftedItemParseResults craftedResults = WynnItemParser.parseCraftedItem(itemStack);
        if (craftedResults == null) {
            return null;
        }
        if (craftedResults.effectStrength() == -1) {
            return null;
        }
        CappedValue durability = new CappedValue(result.durabilityCurrent(), result.durabilityMax());
        GearType gearType = GearType.fromString(result.itemType());
        if (gearType == null && result.requirements().classType().isPresent()) {
            gearType = GearType.fromClassType(result.requirements().classType().get());
        }
        if (gearType == null && (gearType = GearType.fromItemStack(itemStack, true)) == null) {
            gearType = GearType.WEAPON;
        }
        return new CraftedGearItem(craftedResults.name(), craftedResults.effectStrength(), gearType, result.attackSpeed(), result.health(), result.damages(), result.defences(), result.requirements(), possibleValuesMap.values().stream().toList(), result.identifications(), result.powders(), result.powderSlots(), result.allRequirementsMet(), durability);
    }

    public UnknownGearItem parseUnknownGearItem(String name, GearType gearType, GearTier gearTier, boolean isUnidentified, class_1799 itemStack) {
        WynnItemParseResult result = WynnItemParser.parseItemStack(itemStack, null);
        if (gearType == GearType.WEAPON) {
            gearType = result.requirements().classType().map(GearType::fromClassType).orElse(gearType);
        }
        return new UnknownGearItem(name, gearType, gearTier, isUnidentified, result.level(), result.attackSpeed(), result.health(), result.damages(), result.defences(), result.requirements(), result.allRequirementsMet(), result.identifications(), result.powders(), result.powderSlots(), result.rerolls(), result.setInstance().orElse(null), result.shinyStat().orElse(null));
    }

    public GearInfo getGearInfoFromDisplayName(String gearName) {
        return this.gearInfoRegistry.getFromDisplayName(gearName);
    }

    public GearInfo getGearInfoFromApiName(String apiName) {
        return this.gearInfoRegistry.getFromApiName(apiName);
    }

    public List<ItemObtainInfo> getObtainInfo(GearInfo gearInfo) {
        ArrayList<ItemObtainInfo> obtainInfo = new ArrayList<ItemObtainInfo>(gearInfo.metaInfo().obtainInfo());
        if (obtainInfo.size() == 1 && ((ItemObtainInfo)obtainInfo.getFirst()).equals(ItemObtainInfo.UNKNOWN)) {
            obtainInfo.clear();
        }
        obtainInfo.addAll(Models.WynnItem.getObtainInfo(gearInfo.name()));
        return obtainInfo;
    }

    public Stream<GearInfo> getAllGearInfos() {
        return this.gearInfoRegistry.getGearInfoStream();
    }
}

