/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.gear;

import com.google.gson.reflect.TypeToken;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.json.JsonManager;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.gear.type.SetInfo;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.properties.SetItemProperty;
import com.wynntils.models.stats.type.StatType;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1799;

public final class SetModel
extends Model {
    private final Map<String, SetInfo> setData = new HashMap<String, SetInfo>();

    public SetModel() {
        super(List.of());
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_STATIC_ITEM_SETS).handleReader(this::handleSetData);
    }

    public SetInfo getSetInfo(String setName) {
        return this.setData.getOrDefault(setName, null);
    }

    public SetInfo getSetInfoForItem(String itemName) {
        return this.getSetInfo(this.getSetName(itemName));
    }

    public String getSetName(String itemName) {
        for (Map.Entry<String, SetInfo> entry : this.setData.entrySet()) {
            if (!entry.getValue().items().contains(itemName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Set<String> getUniqueSetNames() {
        HashSet<String> returnable = new HashSet<String>();
        for (class_1799 itemStack : Models.Inventory.getEquippedItems()) {
            Optional<GearItem> gear = Models.Item.asWynnItem(itemStack, GearItem.class);
            if (!gear.isPresent() || gear.get().getGearTier() != GearTier.SET || !gear.get().getSetInfo().isPresent()) continue;
            returnable.add(gear.get().getSetInfo().get().name());
        }
        return returnable;
    }

    public int getTrueCount(String setName) {
        int trueCount = 0;
        for (class_1799 itemStack : Models.Inventory.getEquippedItems()) {
            Optional<SetItemProperty> setItemProperty = Models.Item.asWynnItemProperty(itemStack, SetItemProperty.class);
            if (setItemProperty.isEmpty() || setItemProperty.get().getSetInfo().isEmpty() || !setItemProperty.get().getSetInfo().get().name().equals(setName)) continue;
            ++trueCount;
        }
        return trueCount;
    }

    public boolean hasSetData() {
        return !this.setData.isEmpty();
    }

    private void handleSetData(Reader reader) {
        TypeToken<Map<String, RawSetInfo>> type = new TypeToken<Map<String, RawSetInfo>>(this){};
        Map rawSets = (Map)JsonManager.GSON.fromJson(reader, type.getType());
        rawSets.forEach((setName, rawSetInfo) -> {
            List<Map<StatType, Integer>> bonuses = rawSetInfo.bonuses.stream().map(bonusPair -> {
                HashMap<StatType, Integer> bonusMap = new HashMap<StatType, Integer>();
                for (Map.Entry entry : bonusPair.entrySet()) {
                    StatType statType = Models.Stat.fromApiName((String)entry.getKey());
                    if (statType == null) {
                        WynntilsMod.warn("Unknown stat type: " + (String)entry.getKey());
                        continue;
                    }
                    bonusMap.put(statType, (Integer)entry.getValue());
                }
                return bonusMap;
            }).toList();
            this.setData.put((String)setName, new SetInfo((String)setName, bonuses, rawSetInfo.items));
        });
    }

    private static class RawSetInfo {
        public List<Map<String, Integer>> bonuses;
        public List<String> items;

        private RawSetInfo() {
        }
    }
}

