/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items;

import com.wynntils.core.components.Model;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.encoding.ItemTransformerRegistry;
import com.wynntils.models.items.encoding.type.EncodingSettings;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.properties.CraftedItemProperty;
import com.wynntils.utils.EncodedByteBuffer;
import com.wynntils.utils.type.ErrorOr;
import java.util.List;
import java.util.regex.Pattern;

public final class ItemEncodingModel
extends Model {
    @Persisted
    public final Storage<Boolean> extendedIdentificationEncoding = new Storage<Boolean>(false);
    @Persisted
    public final Storage<Boolean> shareItemName = new Storage<Boolean>(true);
    private static final String RANGE_A = "[" + new String(Character.toChars(983040)) + "-" + new String(Character.toChars(1048573)) + "]";
    private static final String RANGE_B = "[" + new String(Character.toChars(0x100000)) + "-" + new String(Character.toChars(1114109)) + "]";
    private static final Pattern ENCODED_DATA_PATTERN = Pattern.compile("(?<data>(" + RANGE_A + "|" + RANGE_B + ")+)( \"(?<name>.+)\")?");
    private final ItemTransformerRegistry itemTransformerRegistry = new ItemTransformerRegistry();

    public ItemEncodingModel() {
        super(List.of());
    }

    public ErrorOr<EncodedByteBuffer> encodeItem(WynnItem wynnItem, EncodingSettings encodingSettings) {
        return this.itemTransformerRegistry.encodeItem(wynnItem, encodingSettings);
    }

    public ErrorOr<WynnItem> decodeItem(EncodedByteBuffer encodedByteBuffer, String itemName) {
        return this.itemTransformerRegistry.decodeItem(encodedByteBuffer, itemName);
    }

    public boolean canEncodeItem(WynnItem wynnItem) {
        return this.itemTransformerRegistry.canEncodeItem(wynnItem);
    }

    public Pattern getEncodedDataPattern() {
        return ENCODED_DATA_PATTERN;
    }

    public String makeItemString(WynnItem wynnItem, EncodedByteBuffer encodedItem) {
        Object itemName = "";
        if (((Boolean)this.shareItemName.get()).booleanValue() && !(wynnItem instanceof GearItem) && wynnItem instanceof CraftedItemProperty) {
            CraftedItemProperty craftedItemProperty = (CraftedItemProperty)((Object)wynnItem);
            itemName = " \"" + craftedItemProperty.getName() + "\"";
        }
        return encodedItem.toUtf16String() + (String)itemName;
    }
}

