/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class WynnItemData {
    public static final String ITEMSTACK_KEY = "itemstack";
    public static final String HIGHLIGHT_KEY = "highlight";
    public static final String OVERLAY_KEY = "overlay";
    public static final String TOOLTIP_KEY = "tooltip";
    public static final String SEARCHED_KEY = "searched";
    public static final String FAVORITE_KEY = "favorite";
    public static final String EMERALD_PRICE_KEY = "price";
    private final Map<String, Object> cache = new HashMap<String, Object>();

    public <T> T get(String key) {
        return (T)this.cache.get(key);
    }

    public <T> T getOrCalculate(String key, Supplier<T> calculator) {
        if (!this.cache.containsKey(key)) {
            T value = calculator.get();
            this.store(key, value);
            return value;
        }
        return this.get(key);
    }

    public <T> void store(String key, T obj) {
        this.cache.put(key, obj);
    }

    public <T> void clear(String key) {
        this.cache.remove(key);
    }

    public void clearAll() {
        this.cache.clear();
    }
}

