/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.annotators.gui;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.item.GuiItemAnnotator;
import com.wynntils.handlers.item.ItemAnnotation;
import com.wynntils.models.ingredients.type.IngredientInfo;
import com.wynntils.models.items.items.gui.IngredientPouchItem;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public final class IngredientPouchAnnotator
implements GuiItemAnnotator {
    private static final Pattern INGREDIENT_POUCH_PATTERN = Pattern.compile("\u00a76[a-zA-Z0-9]+(?:'s)? Pouch");
    private static final Pattern INGREDIENT_LORE_LINE_PATTERN = Pattern.compile("^\u00a7f(\\d+) x \u00a77([^\u00a7]*) (?:\u00a7[3567])?\\[\u00a7([8bde])\u272b(\u00a78)?\u272b(\u00a78)?\u272b\u00a7[3567]\\](?:\u00a7r)?$");

    @Override
    public ItemAnnotation getAnnotation(class_1799 itemStack, StyledText name) {
        if (itemStack.method_7909() != class_1802.field_8574) {
            return null;
        }
        if (!name.matches(INGREDIENT_POUCH_PATTERN)) {
            return null;
        }
        ArrayList<Pair<IngredientInfo, Integer>> ingredients = new ArrayList<Pair<IngredientInfo, Integer>>();
        LinkedList<StyledText> lore = LoreUtils.getLore(itemStack);
        for (StyledText line : lore) {
            Matcher matcher = line.getMatcher(INGREDIENT_LORE_LINE_PATTERN);
            if (!matcher.matches()) continue;
            int count = Integer.parseInt(matcher.group(1));
            String ingredientName = matcher.group(2);
            String tierColor = matcher.group(3);
            int tier = Models.Ingredient.getTierFromColorCode(tierColor);
            IngredientInfo ingredientInfo = Models.Ingredient.getIngredientInfoFromName(ingredientName);
            if (ingredientInfo == null && (ingredientInfo = Models.Ingredient.getIngredientInfoFromApiName(ingredientName)) == null) continue;
            if (ingredientInfo.tier() != tier) {
                WynntilsMod.warn("Incorrect tier (pouch) in ingredient database: " + ingredientName + " is currently " + tier + " vs API " + ingredientInfo.tier());
            }
            ingredients.add(Pair.of(ingredientInfo, count));
        }
        return new IngredientPouchItem(ingredients);
    }
}

