/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.impl.block;

import com.wynntils.models.elements.type.Element;
import com.wynntils.models.items.encoding.data.DefenseData;
import com.wynntils.models.items.encoding.type.DataTransformer;
import com.wynntils.models.items.encoding.type.DataTransformerType;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.utils.UnsignedByteUtils;
import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.UnsignedByte;
import java.util.ArrayList;
import java.util.List;

public class DefenseDataTransformer
extends DataTransformer<DefenseData> {
    @Override
    protected ErrorOr<UnsignedByte[]> encodeData(ItemTransformingVersion version, DefenseData data) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.encodeDefenseData(data);
    }

    @Override
    public ErrorOr<DefenseData> decodeData(ItemTransformingVersion version, ArrayReader<UnsignedByte> byteReader) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.decodeDefenseData(byteReader);
    }

    @Override
    public byte getId() {
        return DataTransformerType.DEFENSE_DATA_TRANSFORMER.getId();
    }

    @Override
    protected boolean shouldEncodeData(ItemTransformingVersion version, DefenseData data) {
        return data.health() != 0 || !data.defences().isEmpty();
    }

    private ErrorOr<UnsignedByte[]> encodeDefenseData(DefenseData data) {
        UnsignedByte[] unsignedBytes = UnsignedByteUtils.encodeVariableSizedInteger(data.health());
        ArrayList<UnsignedByte> bytes = new ArrayList<UnsignedByte>(List.of(unsignedBytes));
        bytes.add(UnsignedByte.of((byte)data.defences().size()));
        for (Pair<Element, Integer> defence : data.defences()) {
            bytes.add(UnsignedByte.of((byte)defence.a().getEncodingId()));
            unsignedBytes = UnsignedByteUtils.encodeVariableSizedInteger(defence.b().intValue());
            bytes.addAll(List.of(unsignedBytes));
        }
        return ErrorOr.of(bytes.toArray(new UnsignedByte[0]));
    }

    private ErrorOr<DefenseData> decodeDefenseData(ArrayReader<UnsignedByte> byteReader) {
        int health = (int)UnsignedByteUtils.decodeVariableSizedInteger(byteReader);
        int defencesCount = byteReader.read().value();
        ArrayList<Pair<Element, Integer>> defences = new ArrayList<Pair<Element, Integer>>();
        for (int i = 0; i < defencesCount; ++i) {
            short elementTypeId = byteReader.read().value();
            Element element = Element.fromEncodingId(elementTypeId);
            if (element == null) {
                return ErrorOr.error("Invalid element encoding: " + elementTypeId);
            }
            int defence = (int)UnsignedByteUtils.decodeVariableSizedInteger(byteReader);
            defences.add(Pair.of(element, defence));
        }
        return ErrorOr.of(new DefenseData(health, defences));
    }
}

