/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.impl.block;

import com.wynntils.models.items.encoding.data.NameData;
import com.wynntils.models.items.encoding.type.DataTransformer;
import com.wynntils.models.items.encoding.type.DataTransformerType;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.utils.UnsignedByteUtils;
import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.UnsignedByte;
import java.util.ArrayList;

public class NameDataTransformer
extends DataTransformer<NameData> {
    @Override
    public ErrorOr<UnsignedByte[]> encodeData(ItemTransformingVersion version, NameData data) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.encodeName(data.name().orElse(""));
    }

    @Override
    public ErrorOr<NameData> decodeData(ItemTransformingVersion version, ArrayReader<UnsignedByte> byteReader) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.decodeName(byteReader);
    }

    private ErrorOr<UnsignedByte[]> encodeName(String name) {
        try {
            return ErrorOr.of(UnsignedByteUtils.encodeString(name));
        }
        catch (IllegalArgumentException e) {
            return ErrorOr.error("Name contains non-ASCII characters");
        }
    }

    private ErrorOr<NameData> decodeName(ArrayReader<UnsignedByte> byteReader) {
        ArrayList<UnsignedByte> bytes = new ArrayList<UnsignedByte>();
        do {
            bytes.add(byteReader.read());
        } while (byteReader.hasRemaining() && byteReader.peek().value() != 0);
        UnsignedByte nullByte = byteReader.read();
        if (nullByte.value() != 0) {
            return ErrorOr.error("Name data is not null terminated");
        }
        return ErrorOr.of(NameData.sanitized(UnsignedByteUtils.decodeString(bytes)));
    }

    @Override
    public byte getId() {
        return DataTransformerType.NAME_DATA_TRANSFORMER.getId();
    }
}

