/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.encoding.impl.block;

import com.wynntils.core.WynntilsMod;
import com.wynntils.models.elements.type.Element;
import com.wynntils.models.elements.type.Powder;
import com.wynntils.models.items.encoding.data.PowderData;
import com.wynntils.models.items.encoding.type.DataTransformer;
import com.wynntils.models.items.encoding.type.DataTransformerType;
import com.wynntils.models.items.encoding.type.ItemTransformingVersion;
import com.wynntils.utils.UnsignedByteUtils;
import com.wynntils.utils.type.ArrayReader;
import com.wynntils.utils.type.ErrorOr;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.UnsignedByte;
import java.util.ArrayList;
import java.util.stream.Stream;

public class PowderDataTransformer
extends DataTransformer<PowderData> {
    @Override
    public ErrorOr<UnsignedByte[]> encodeData(ItemTransformingVersion version, PowderData data) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.encodePowderData(data);
    }

    @Override
    protected boolean shouldEncodeData(ItemTransformingVersion version, PowderData data) {
        return !data.powders().isEmpty() || data.powderSlots() > 0;
    }

    @Override
    public ErrorOr<PowderData> decodeData(ItemTransformingVersion version, ArrayReader<UnsignedByte> byteReader) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case VERSION_1: 
            case VERSION_2: 
        }
        return this.decodePowderData(byteReader);
    }

    @Override
    public byte getId() {
        return DataTransformerType.POWDER_DATA_TRANSFORMER.getId();
    }

    private ErrorOr<UnsignedByte[]> encodePowderData(PowderData data) {
        int i;
        int bitsNeeded = data.powders().size() * 5;
        int totalBits = (bitsNeeded + 7) / 8 * 8;
        boolean[] powderData = new boolean[totalBits];
        for (i = 0; i < data.powders().size(); ++i) {
            Pair<Powder, Integer> powder = data.powders().get(i);
            int element = powder.key().getElement().getEncodingId();
            int tier = powder.value();
            int powderDataIndex = i * 5;
            for (int j = 0; j < 5; ++j) {
                boolean value;
                int index = powderDataIndex + (4 - j);
                powderData[index] = value = (element * 6 + tier >> j) % 2 != 0;
            }
        }
        for (i = bitsNeeded; i < totalBits; ++i) {
            powderData[i] = false;
        }
        UnsignedByte[] dataBytes = UnsignedByteUtils.fromBitArray(powderData);
        if (data.powders().size() > 255) {
            return ErrorOr.error("Too many powders on item.");
        }
        if (data.powderSlots() > 255) {
            return ErrorOr.error("Too many powder slots on item.");
        }
        return ErrorOr.of((UnsignedByte[])Stream.concat(Stream.of(UnsignedByte.of((byte)data.powderSlots()), UnsignedByte.of((byte)data.powders().size())), Stream.of(dataBytes)).toArray(UnsignedByte[]::new));
    }

    private ErrorOr<PowderData> decodePowderData(ArrayReader<UnsignedByte> byteReader) {
        short powderSlots = byteReader.read().value();
        short powderCount = byteReader.read().value();
        if (powderCount > powderSlots) {
            WynntilsMod.warn("Powder count is greater than powder slots. This should not happen.");
        }
        int bitsNeeded = powderCount * 5;
        int totalBits = (bitsNeeded + 7) / 8 * 8;
        UnsignedByte[] powderData = byteReader.read(totalBits / 8);
        boolean[] powderBits = UnsignedByteUtils.toBitArray(powderData);
        boolean[] powderDataBits = new boolean[bitsNeeded];
        System.arraycopy(powderBits, 0, powderDataBits, 0, bitsNeeded);
        ArrayList<Pair<Powder, Integer>> data = new ArrayList<Pair<Powder, Integer>>();
        for (int i = 0; i < Math.min(powderCount, powderSlots); ++i) {
            Powder powder;
            int powderDataIndex = i * 5;
            int powderValue = 0;
            for (int j = 0; j < 5; ++j) {
                int index = powderDataIndex + (4 - j);
                boolean value = powderDataBits[index];
                if (!value) continue;
                powderValue |= 1 << j;
            }
            if (powderValue == 0) continue;
            int element = powderValue / 6;
            int tier = powderValue % 6;
            if (tier == 0) {
                --element;
                tier = 6;
            }
            if ((powder = Powder.fromElement(Element.fromEncodingId(element))) == null) {
                return ErrorOr.error("Invalid powder element encoding: " + element);
            }
            data.add(new Pair<Powder, Integer>(powder, tier));
        }
        return ErrorOr.of(new PowderData(powderSlots, data));
    }
}

