/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.items.game;

import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.gear.type.GearType;
import com.wynntils.models.items.items.game.GameItem;
import com.wynntils.models.items.properties.GearTierItemProperty;
import com.wynntils.models.items.properties.LeveledItemProperty;
import com.wynntils.utils.type.RangedValue;
import java.util.Objects;

public class GearBoxItem
extends GameItem
implements GearTierItemProperty,
LeveledItemProperty {
    private final GearType gearType;
    private final GearTier gearTier;
    private final RangedValue levelRange;

    public GearBoxItem(GearType gearType, GearTier gearTier, RangedValue levelRange) {
        this.gearType = gearType;
        this.gearTier = gearTier;
        this.levelRange = levelRange;
    }

    public GearType getGearType() {
        return this.gearType;
    }

    @Override
    public GearTier getGearTier() {
        return this.gearTier;
    }

    public RangedValue getLevelRange() {
        return this.levelRange;
    }

    @Override
    public int getLevel() {
        return this.levelRange.high();
    }

    @Override
    public String toString() {
        return "GearBoxItem{gearType=" + String.valueOf((Object)this.gearType) + ", gearTier=" + String.valueOf((Object)this.gearTier) + ", levelRange='" + String.valueOf(this.levelRange) + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GearBoxItem that = (GearBoxItem)o;
        return this.gearType == that.gearType && this.gearTier == that.gearTier && Objects.equals(this.levelRange, that.levelRange);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.gearType, this.gearTier, this.levelRange});
    }
}

