/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.items.items.gui;

import com.wynntils.models.items.items.gui.GuiItem;
import com.wynntils.models.territories.type.GuildResource;
import com.wynntils.models.territories.type.GuildResourceValues;
import com.wynntils.models.territories.type.TerritoryUpgrade;
import com.wynntils.utils.type.CappedValue;
import java.util.List;
import java.util.Map;

public class TerritoryItem
extends GuiItem {
    private final String name;
    private final boolean isHeadquarters;
    private final boolean isSelected;
    private final Map<GuildResource, Integer> production;
    private final Map<GuildResource, CappedValue> storage;
    private final float treasuryBonus;
    private final List<String> alerts;
    private final Map<TerritoryUpgrade, Integer> upgrades;

    public TerritoryItem(String name, boolean isHeadquarters, boolean isSelected, Map<GuildResource, Integer> production, Map<GuildResource, CappedValue> storage, float treasuryBonus, List<String> alerts, Map<TerritoryUpgrade, Integer> upgrades) {
        this.name = name;
        this.isHeadquarters = isHeadquarters;
        this.isSelected = isSelected;
        this.production = production;
        this.storage = storage;
        this.treasuryBonus = treasuryBonus;
        this.alerts = alerts;
        this.upgrades = upgrades;
    }

    public String getName() {
        return this.name;
    }

    public boolean isHeadquarters() {
        return this.isHeadquarters;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public Map<GuildResource, Integer> getProduction() {
        return this.production;
    }

    public Map<GuildResource, CappedValue> getStorage() {
        return this.storage;
    }

    public float getTreasuryBonus() {
        return this.treasuryBonus;
    }

    public List<String> getAlerts() {
        return this.alerts;
    }

    public Map<TerritoryUpgrade, Integer> getUpgrades() {
        return this.upgrades;
    }

    public GuildResourceValues getDefenseDifficulty() {
        int total = 0;
        for (Map.Entry<TerritoryUpgrade, Integer> entry : this.upgrades.entrySet()) {
            switch (entry.getKey()) {
                case DAMAGE: 
                case ATTACK: 
                case HEALTH: 
                case DEFENCE: 
                case TOWER_AURA: 
                case TOWER_VOLLEY: {
                    total += entry.getValue().intValue();
                }
            }
        }
        if (this.upgrades.getOrDefault((Object)TerritoryUpgrade.TOWER_AURA, 0) == 0) {
            total -= 5;
        }
        if (this.upgrades.getOrDefault((Object)TerritoryUpgrade.TOWER_VOLLEY, 0) == 0) {
            total -= 3;
        }
        if (total < -2) {
            return GuildResourceValues.VERY_LOW;
        }
        if (total < 11) {
            return GuildResourceValues.LOW;
        }
        if (total < 23) {
            return GuildResourceValues.MEDIUM;
        }
        if (total < 41) {
            return GuildResourceValues.HIGH;
        }
        return GuildResourceValues.VERY_HIGH;
    }

    @Override
    public String toString() {
        return "TerritoryItem{name='" + this.name + "', generation=" + String.valueOf(this.production) + ", storage=" + String.valueOf(this.storage) + ", treasuryBonus=" + this.treasuryBonus + ", alerts=" + String.valueOf(this.alerts) + ", upgrades=" + String.valueOf(this.upgrades) + "}";
    }
}

