/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.lootrun.beacons;

import com.wynntils.core.text.StyledText;
import com.wynntils.models.beacons.type.BeaconMarkerKind;
import com.wynntils.models.lootrun.type.LootrunTaskType;
import java.util.regex.Pattern;

public enum LootrunBeaconMarkerKind implements BeaconMarkerKind
{
    SLAY("\ue00b", LootrunTaskType.SLAY),
    TARGET("\ue00c", LootrunTaskType.TARGET),
    DEFEND("\ue00d", LootrunTaskType.DEFEND),
    SPELUNK("\ue00e", LootrunTaskType.LOOT),
    DESTROY("\ue00f", LootrunTaskType.DESTROY);

    private static final String MARKER_PREFIX = "\udaff\udff8[\ue010-\ue014]\udaff\udfde";
    private static final String MARKER_SUFFIX = "\n(\\d+m (\u00a7[a-z0-9])?(\ue000|\ue001)?)?";
    private final Pattern iconPattern;
    private final LootrunTaskType taskType;

    private LootrunBeaconMarkerKind(String iconCharacter, LootrunTaskType taskType) {
        this.iconPattern = Pattern.compile("\udaff\udff8[\ue010-\ue014]\udaff\udfde\u00a7(?:#)?(?:[a-z0-9]{1,8})\ue000(\u00a7r)?\udaff\udfe6" + iconCharacter + MARKER_SUFFIX);
        this.taskType = taskType;
    }

    public LootrunTaskType getTaskType() {
        return this.taskType;
    }

    @Override
    public boolean matches(StyledText styledText) {
        return styledText.matches(this.iconPattern);
    }
}

