/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.lootrun.type;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;

public enum MissionType {
    UNKNOWN("Unknown", class_124.field_1068),
    FAILED("Failed", class_124.field_1079),
    CLEANSING_GREED("Cleansing Greed", class_124.field_1054),
    HIGH_ROLLER("High Roller", class_124.field_1054, 0, 1),
    HOARDER("Hoarder", class_124.field_1054),
    MATERIALISM("Materialism", class_124.field_1054),
    GOURMAND("Gourmand", class_124.field_1078),
    ORPHIONS_GRACE("Orphion's Grace", class_124.field_1078),
    PORPHYROPHOBIA("Porphyrophobia", class_124.field_1078),
    CHRONOKINESIS("Chronokinesis", class_124.field_1078),
    CLEANSING_RITUAL("Cleansing Ritual", class_124.field_1064),
    EQUILIBRIUM("Equilibrium", class_124.field_1064),
    INNER_PEACE("Inner Peace", class_124.field_1064),
    COMPLETE_CHAOS("Complete Chaos", class_124.field_1064),
    JESTERS_TRICK("Jester's Trick", class_124.field_1064),
    INTEREST_SCHEME("Interest Scheme", class_124.field_1064),
    BACKUP_BEAT("Backup Beat", class_124.field_1060),
    STASIS("Stasis", class_124.field_1060),
    OPTIMISM("Optimism", class_124.field_1060),
    REDEMPTION("Redemption", class_124.field_1061, 1, 0),
    THRILL_SEEKER("Thrill Seeker", class_124.field_1061);

    private final String name;
    private final class_124 color;
    private final int sacrifices;
    private final int rerolls;

    private MissionType(String name, class_124 color) {
        this.name = name;
        this.color = color;
        this.sacrifices = 0;
        this.rerolls = 0;
    }

    private MissionType(String name, class_124 color, int sacrifices, int rerolls) {
        this.name = name;
        this.color = color;
        this.sacrifices = sacrifices;
        this.rerolls = rerolls;
    }

    public String getName() {
        return this.name;
    }

    public String getColoredName() {
        return String.valueOf(this.color) + this.name;
    }

    public class_124 getColor() {
        return this.color;
    }

    public int getSacrifices() {
        return this.sacrifices;
    }

    public int getRerolls() {
        return this.rerolls;
    }

    public static MissionType fromName(String name) {
        for (MissionType type : MissionType.values()) {
            if (type == UNKNOWN || type == FAILED || !type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return UNKNOWN;
    }

    public static List<MissionType> missionTypes() {
        return Arrays.stream(MissionType.values()).filter(type -> type != UNKNOWN && type != FAILED).toList();
    }
}

