/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.marker;

import com.wynntils.core.components.Model;
import com.wynntils.models.marker.UserWaypointMarkerProvider;
import com.wynntils.models.marker.type.MarkerInfo;
import com.wynntils.models.marker.type.MarkerProvider;
import com.wynntils.services.map.pois.Poi;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public final class MarkerModel
extends Model {
    public static final UserWaypointMarkerProvider USER_WAYPOINTS_PROVIDER = new UserWaypointMarkerProvider();
    private final List<MarkerProvider> markerProviders = new ArrayList<MarkerProvider>();

    public MarkerModel() {
        super(List.of());
        this.registerMarkerProvider(USER_WAYPOINTS_PROVIDER);
    }

    public void registerMarkerProvider(MarkerProvider provider) {
        this.markerProviders.add(provider);
    }

    public Stream<MarkerInfo> getAllMarkers() {
        return this.markerProviders.stream().filter(MarkerProvider::isEnabled).flatMap(MarkerProvider::getMarkerInfos);
    }

    public Stream<Poi> getAllPois() {
        return this.markerProviders.stream().filter(MarkerProvider::isEnabled).flatMap(MarkerProvider::getPois);
    }
}

