/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.players;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.chat.type.MessageType;
import com.wynntils.handlers.scoreboard.ScoreboardPart;
import com.wynntils.mc.event.SetPlayerTeamEvent;
import com.wynntils.models.players.event.HadesRelationsUpdateEvent;
import com.wynntils.models.players.event.PartyEvent;
import com.wynntils.models.players.scoreboard.PartyScoreboardPart;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.services.hades.event.HadesEvent;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.StyledTextUtils;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class PartyModel
extends Model {
    private static final String PARTY_PREFIX_REGEX = "\u00a7e(?:\ue005\ue002|\ue001) ";
    private static final Pattern PARTY_LIST_ALL = Pattern.compile("\u00a7e(?:\ue005\ue002|\ue001) Party members: (.*)");
    private static final Pattern PARTY_LIST_LEADER = Pattern.compile("\u00a7b([a-zA-Z0-9_]+)");
    private static final Pattern PARTY_COMMAND_FAILED = Pattern.compile("\u00a7e(?:\ue005\ue002|\ue001) You must be in a party to use this\\.");
    private static final Pattern PARTY_PLAYER_LEFT = Pattern.compile("\u00a7e(?:\ue005\ue002|\ue001) You have left your current party");
    private static final Pattern PARTY_PLAYER_KICKED = Pattern.compile("\u00a7e(?:\ue005\ue002|\ue001) You have been kicked from your party");
    private static final Pattern PARTY_PLAYER_DISBANDED = Pattern.compile("\u00a7e(?:\ue005\ue002|\ue001) Your party has been disbanded");
    private static final Pattern PARTY_PLAYER_CREATED = Pattern.compile("\u00a7e(?:\ue005\ue002|\ue001) You have successfully created a party\\.");
    private static final Pattern PARTY_SOMEONE_JOINED = Pattern.compile("\u00a7e(?:\ue005\ue002|\ue001) (.+) has joined your party, say hello!");
    private static final Pattern PARTY_OTHER_LEFT = Pattern.compile("\u00a7e(?:\ue005\ue002|\ue001) (.+) has left the party!");
    private static final Pattern PARTY_OTHER_KICKED = Pattern.compile("\u00a7e(?:\ue005\ue002|\ue001) (.+) has been kicked from the party!");
    private static final Pattern PARTY_NEW_LEADER = Pattern.compile("\u00a7e(?:\ue005\ue002|\ue001) (?:\u00a7c)?(.+)\u00a7e is now the Party Leader!.*");
    private static final Pattern PARTY_RESTORED_SELF = Pattern.compile("\u00a7e(?:\ue005\ue002|\ue001) Your previous party was restored");
    private static final Pattern PARTY_INVITED = Pattern.compile("(?:\u00a7e(?:\ue005\ue002|\ue001) |\\s+\u00a7e)You have been invited to join (.+)'s? party!\\s*");
    private static final ScoreboardPart PARTY_SCOREBOARD_PART = new PartyScoreboardPart();
    public static final int MAX_PARTY_MEMBER_COUNT = 10;
    private boolean expectingPartyMessage = false;
    private long lastPartyRequest = 0L;
    private boolean inParty;
    private String partyLeader = null;
    private List<String> partyMembers = new ArrayList<String>();
    private Set<String> offlineMembers = new HashSet<String>();

    public PartyModel() {
        super(List.of());
        this.resetData();
        Handlers.Scoreboard.addPart(PARTY_SCOREBOARD_PART);
    }

    @SubscribeEvent
    public void onAuth(HadesEvent.Authenticated event) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        this.requestData();
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() == WorldState.WORLD) {
            this.requestData();
        } else {
            this.resetData();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChatReceived(ChatMessageEvent.Match event) {
        if (event.getMessageType() != MessageType.FOREGROUND) {
            return;
        }
        StyledText chatMessage = StyledTextUtils.unwrap(event.getMessage()).stripAlignment();
        if (this.tryParsePartyMessages(chatMessage)) {
            return;
        }
        if (this.expectingPartyMessage && (this.tryParseNoPartyMessage(chatMessage) || this.tryParsePartyList(chatMessage))) {
            event.setCanceled(true);
            this.expectingPartyMessage = false;
            return;
        }
    }

    private boolean tryParsePartyMessages(StyledText styledText) {
        if (styledText.matches(PARTY_PLAYER_CREATED)) {
            WynntilsMod.info("Player created a new party.");
            this.inParty = true;
            this.partyLeader = McUtils.playerName();
            this.partyMembers = new ArrayList<String>(List.of(this.partyLeader));
            WynntilsMod.postEvent(new HadesRelationsUpdateEvent.PartyList(Set.copyOf(this.partyMembers), HadesRelationsUpdateEvent.ChangeType.RELOAD));
            WynntilsMod.postEvent(new PartyEvent.Listed());
            return true;
        }
        if (styledText.matches(PARTY_PLAYER_LEFT) || styledText.matches(PARTY_PLAYER_DISBANDED) || styledText.matches(PARTY_PLAYER_KICKED)) {
            WynntilsMod.info("Player is no longer in a party.");
            this.resetData();
            return true;
        }
        Matcher matcher = styledText.getMatcher(PARTY_SOMEONE_JOINED);
        if (matcher.matches()) {
            Pair<String, String> possibleNameAndNick = StyledTextUtils.extractNameAndNick(styledText);
            String player = possibleNameAndNick != null ? possibleNameAndNick.a() : matcher.group(1);
            if (player.equals(McUtils.playerName())) {
                WynntilsMod.info("Player joined a new party, requesting party list.");
                this.requestData();
            } else {
                WynntilsMod.info("Player's party has a new member: " + player);
                this.partyMembers.add(player);
                WynntilsMod.postEvent(new HadesRelationsUpdateEvent.PartyList(Set.of(player), HadesRelationsUpdateEvent.ChangeType.ADD));
                WynntilsMod.postEvent(new PartyEvent.OtherJoined(player));
            }
            return true;
        }
        matcher = styledText.getMatcher(PARTY_OTHER_LEFT);
        if (matcher.matches()) {
            Pair<String, String> possibleNameAndNick = StyledTextUtils.extractNameAndNick(styledText);
            String player = possibleNameAndNick != null ? possibleNameAndNick.a() : matcher.group(1);
            WynntilsMod.info("Other player left player's party: " + player);
            this.partyMembers.remove(player);
            WynntilsMod.postEvent(new HadesRelationsUpdateEvent.PartyList(Set.of(player), HadesRelationsUpdateEvent.ChangeType.REMOVE));
            WynntilsMod.postEvent(new PartyEvent.OtherLeft(player));
            return true;
        }
        matcher = styledText.getMatcher(PARTY_OTHER_KICKED);
        if (matcher.matches()) {
            Pair<String, String> possibleNameAndNick = StyledTextUtils.extractNameAndNick(styledText);
            String player = possibleNameAndNick != null ? possibleNameAndNick.a() : matcher.group(1);
            WynntilsMod.info("Other player was kicked from player's party: " + player);
            this.partyMembers.remove(player);
            WynntilsMod.postEvent(new HadesRelationsUpdateEvent.PartyList(Set.of(player), HadesRelationsUpdateEvent.ChangeType.REMOVE));
            WynntilsMod.postEvent(new PartyEvent.OtherLeft(player));
            return true;
        }
        matcher = styledText.getMatcher(PARTY_NEW_LEADER);
        if (matcher.matches()) {
            Pair<String, String> possibleNameAndNick = StyledTextUtils.extractNameAndNick(styledText);
            String player = possibleNameAndNick != null ? possibleNameAndNick.a() : matcher.group(1);
            WynntilsMod.info("Player's party has a new leader: " + player);
            String oldLeader = this.partyLeader;
            this.partyLeader = player;
            WynntilsMod.postEvent(new PartyEvent.Promoted(oldLeader, this.partyLeader));
            return true;
        }
        matcher = styledText.getMatcher(PARTY_INVITED);
        if (matcher.matches()) {
            Pair<String, String> possibleNameAndNick = StyledTextUtils.extractNameAndNick(styledText);
            String inviter = possibleNameAndNick != null ? possibleNameAndNick.a() : matcher.group(1);
            WynntilsMod.info("Player has been invited to party by " + inviter);
            WynntilsMod.postEvent(new PartyEvent.Invited(inviter));
            return true;
        }
        matcher = styledText.getMatcher(PARTY_RESTORED_SELF);
        if (matcher.matches()) {
            WynntilsMod.info("Player's previous party was restored, requesting party list.");
            this.requestData();
            return true;
        }
        return false;
    }

    private boolean tryParseNoPartyMessage(StyledText styledText) {
        if (styledText.matches(PARTY_COMMAND_FAILED)) {
            this.resetData();
            WynntilsMod.info("Player is not in a party.");
            return true;
        }
        return false;
    }

    private boolean tryParsePartyList(StyledText styledText) {
        Matcher matcher = styledText.getMatcher(PARTY_LIST_ALL);
        if (!matcher.matches()) {
            return false;
        }
        String[] partyList = StyledText.fromString(matcher.group(1)).getStringWithoutFormatting().split("(?:,(?: and)? )");
        ArrayList newPartyMembers = new ArrayList();
        Collections.addAll(newPartyMembers, partyList);
        Matcher leaderMatcher = styledText.getMatcher(PARTY_LIST_LEADER);
        String oldLeader = this.partyLeader;
        this.partyLeader = leaderMatcher.find() ? leaderMatcher.group(1) : McUtils.playerName();
        WynntilsMod.postEvent(new PartyEvent.Promoted(oldLeader, this.partyLeader));
        WynntilsMod.info("Successfully updated party leader, current leader is " + this.partyLeader + ".");
        this.partyMembers = newPartyMembers.stream().sorted(Comparator.comparing(element -> this.partyMembers.indexOf(element))).collect(Collectors.toList());
        this.inParty = true;
        WynntilsMod.postEvent(new HadesRelationsUpdateEvent.PartyList(Set.copyOf(this.partyMembers), HadesRelationsUpdateEvent.ChangeType.RELOAD));
        WynntilsMod.postEvent(new PartyEvent.Listed());
        WynntilsMod.info("Successfully updated party list, user has " + partyList.length + " party members.");
        Collection teamNames = McUtils.mc().field_1687.method_8428().method_1196();
        this.offlineMembers = this.partyMembers.stream().filter(member -> !teamNames.contains(member)).collect(Collectors.toSet());
        WynntilsMod.info("Successfully updated offline members, user's party has " + this.offlineMembers.size() + " offline members.");
        return true;
    }

    private void resetData() {
        this.partyMembers = new ArrayList<String>();
        this.partyLeader = null;
        this.inParty = false;
        this.offlineMembers = new HashSet<String>();
        WynntilsMod.postEvent(new HadesRelationsUpdateEvent.PartyList(Set.copyOf(this.partyMembers), HadesRelationsUpdateEvent.ChangeType.RELOAD));
        WynntilsMod.postEvent(new PartyEvent.Listed());
    }

    public void requestData() {
        if (McUtils.player() == null) {
            return;
        }
        if (System.currentTimeMillis() - this.lastPartyRequest < 250L) {
            WynntilsMod.info("Skipping party list request because it was requested less than 250ms ago.");
            return;
        }
        this.expectingPartyMessage = true;
        this.lastPartyRequest = System.currentTimeMillis();
        Handlers.Command.queueCommand("party list");
    }

    public void increasePlayerPriority(String playerName) {
        int index = this.partyMembers.indexOf(playerName);
        if (index == -1) {
            return;
        }
        this.partyMembers.add(Math.max(0, index - 1), this.partyMembers.remove(index));
        WynntilsMod.postEvent(new PartyEvent.PriorityChanged(playerName, index - 1));
    }

    public void decreasePlayerPriority(String playerName) {
        int index = this.partyMembers.indexOf(playerName);
        if (index == -1) {
            return;
        }
        this.partyMembers.add(Math.min(this.partyMembers.size() - 1, index + 1), this.partyMembers.remove(index));
        WynntilsMod.postEvent(new PartyEvent.PriorityChanged(playerName, index + 1));
    }

    public boolean isInParty() {
        return this.inParty;
    }

    public boolean isPartyLeader(String userName) {
        return userName.equals(this.partyLeader);
    }

    public Optional<String> getPartyLeader() {
        return Optional.ofNullable(this.partyLeader);
    }

    public List<String> getPartyMembers() {
        return this.partyMembers;
    }

    public Set<String> getOfflineMembers() {
        return this.offlineMembers;
    }

    @SubscribeEvent
    public void onSetTeam(SetPlayerTeamEvent e) {
        if (!this.inParty) {
            return;
        }
        if (e.getMethod() == 0) {
            this.offlineMembers.remove(e.getTeamName());
            WynntilsMod.postEvent(new PartyEvent.OtherReconnected(e.getTeamName()));
        } else if (e.getMethod() == 1 && this.partyMembers.contains(e.getTeamName())) {
            this.offlineMembers.add(e.getTeamName());
            WynntilsMod.postEvent(new PartyEvent.OtherDisconnected(e.getTeamName()));
        }
    }

    public void partyKick(String player) {
        Handlers.Command.queueCommand("party kick " + player);
    }

    public void partyPromote(String player) {
        Handlers.Command.queueCommand("party promote " + player);
    }

    public void partyInvite(String player) {
        if (!this.inParty) {
            this.partyCreate();
        }
        Handlers.Command.queueCommand("party invite " + player);
    }

    public void partyLeave() {
        Handlers.Command.queueCommand("party leave");
    }

    public void partyDisband() {
        Handlers.Command.queueCommand("party disband");
    }

    public void partyCreate() {
        Handlers.Command.queueCommand("party create");
    }

    public void partyJoin(String playerName) {
        Handlers.Command.queueCommand("party join " + playerName);
    }

    public void partyKickOffline() {
        HashSet<String> offlineMembersCopy = new HashSet<String>(this.offlineMembers);
        offlineMembersCopy.forEach(this::partyKick);
    }
}

