/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.raid.type;

import com.wynntils.models.raid.raids.RaidKind;
import com.wynntils.models.raid.type.RaidRoomInfo;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class RaidInfo {
    private final RaidKind raidKind;
    private final Map<Integer, RaidRoomInfo> challenges = new TreeMap<Integer, RaidRoomInfo>();
    private final long raidStartTime;

    public RaidInfo(RaidKind raidKind) {
        this.raidKind = raidKind;
        this.raidStartTime = System.currentTimeMillis();
    }

    public void startChallenge(int challengeNum, String roomName) {
        if (this.challenges.containsKey(challengeNum)) {
            return;
        }
        this.challenges.put(challengeNum, new RaidRoomInfo(roomName));
    }

    public void completeCurrentChallenge() {
        if (!this.challenges.containsKey(this.challenges.size())) {
            return;
        }
        this.challenges.get(this.challenges.size()).setRoomEndTime(System.currentTimeMillis());
    }

    public void addDamageToCurrentRoom(long damage) {
        if (!this.challenges.containsKey(this.challenges.size())) {
            return;
        }
        this.challenges.get(this.challenges.size()).addDamage(damage);
    }

    public RaidRoomInfo getCurrentRoom() {
        return this.challenges.getOrDefault(this.challenges.size(), null);
    }

    public RaidRoomInfo getRoomByNumber(int roomNum) {
        if (!this.challenges.containsKey(roomNum)) {
            return null;
        }
        return this.challenges.get(roomNum);
    }

    public long getRaidStartTime() {
        return this.raidStartTime;
    }

    public long getTimeInRaid() {
        return System.currentTimeMillis() - this.raidStartTime;
    }

    public long getIntermissionTime() {
        return this.getTimeInRaid() - this.getTimeInRooms();
    }

    public long getRaidDamage() {
        return this.challenges.values().stream().mapToLong(RaidRoomInfo::getRoomDamage).sum();
    }

    public RaidKind getRaidKind() {
        return this.raidKind;
    }

    public int completedChallengeCount() {
        return this.challenges.size();
    }

    public Map<Integer, RaidRoomInfo> getChallenges() {
        return Collections.unmodifiableMap(this.challenges);
    }

    private long getTimeInRooms() {
        return this.challenges.values().stream().mapToLong(RaidRoomInfo::getRoomTotalTime).sum();
    }
}

