/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.stats;

import com.google.common.reflect.TypeToken;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.json.JsonManager;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import com.wynntils.models.gear.type.GearInstance;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.stats.type.ShinyStat;
import com.wynntils.models.stats.type.ShinyStatType;
import com.wynntils.utils.mc.McUtils;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1799;

public final class ShinyModel
extends Model {
    private Map<String, ShinyStatType> shinyStatTypes = new HashMap<String, ShinyStatType>();

    public ShinyModel() {
        super(List.of());
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_STATIC_SHINY_STATS).handleReader(this::handleShinyStatTypes);
    }

    private void handleShinyStatTypes(Reader reader) {
        Type type = new TypeToken<List<ShinyStatType>>(){}.getType();
        List statTypes = (List)JsonManager.GSON.fromJson(reader, type);
        this.shinyStatTypes = statTypes.stream().collect(Collectors.toMap(ShinyStatType::displayName, statType -> statType));
    }

    public ShinyStatType getShinyStatType(int id) {
        return this.shinyStatTypes.values().stream().filter(statType -> statType.id() == id).findFirst().orElse(ShinyStatType.UNKNOWN);
    }

    public Optional<ShinyStat> getShinyStat(class_1799 itemStack) {
        Optional<GearItem> gearItemOpt = Models.Item.asWynnItem(itemStack, GearItem.class);
        if (gearItemOpt.isEmpty()) {
            return Optional.empty();
        }
        Optional<GearInstance> gearInstanceOpt = gearItemOpt.get().getItemInstance();
        if (gearInstanceOpt.isEmpty()) {
            return Optional.empty();
        }
        return gearInstanceOpt.get().shinyStat();
    }

    public List<ShinyStat> getAllShinyStats() {
        ArrayList<ShinyStat> allShinies = new ArrayList<ShinyStat>();
        int size = McUtils.inventory().method_5439();
        for (int i = 0; i < size; ++i) {
            class_1799 itemStack = McUtils.inventory().method_5438(i);
            Optional<ShinyStat> shinyOpt = this.getShinyStat(itemStack);
            if (!shinyOpt.isPresent()) continue;
            allShinies.add(shinyOpt.get());
        }
        return allShinies;
    }

    public ShinyStatType getShinyStat(String displayName) {
        ShinyStatType shinyStatType = this.shinyStatTypes.get(displayName);
        if (shinyStatType == null) {
            WynntilsMod.warn("Unknown shiny stat type: " + displayName);
            return ShinyStatType.UNKNOWN;
        }
        return shinyStatType;
    }
}

