/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.stats;

import com.wynntils.core.WynntilsMod;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatCalculationInfo;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Optional;

public final class StatCalculator {
    private static final boolean VERIFY_CALCULATED_ROLLS = false;

    public static RangedValue calculatePossibleValuesRange(int baseValue, boolean preIdentified, StatType statType) {
        if (preIdentified) {
            return RangedValue.of(baseValue, baseValue);
        }
        StatCalculationInfo statCalculationInfo = statType.getStatCalculationInfo(baseValue);
        RoundingMode roundingMode = statCalculationInfo.roundingMode();
        int low = new BigDecimal(baseValue).multiply(BigDecimal.valueOf(statCalculationInfo.range().low())).divide(BigDecimal.valueOf(100L), roundingMode).setScale(0, roundingMode).intValue();
        int high = new BigDecimal(baseValue).multiply(BigDecimal.valueOf(statCalculationInfo.range().high())).divide(BigDecimal.valueOf(100L), roundingMode).setScale(0, roundingMode).intValue();
        if (high < low) {
            int temp = low;
            low = high;
            high = temp;
        }
        if (statCalculationInfo.minimumValue().isPresent()) {
            low = Math.max(low, statCalculationInfo.minimumValue().get());
        }
        if (statCalculationInfo.maximumValue().isPresent()) {
            high = Math.min(high, statCalculationInfo.maximumValue().get());
        }
        return RangedValue.of(low, high);
    }

    public static RangedValue calculateInternalRollRange(StatPossibleValues possibleValues, int value, int stars) {
        int baseValue = possibleValues.baseValue();
        if (possibleValues.statType().calculateAsInverted()) {
            baseValue = -baseValue;
            value = -value;
        }
        StatCalculationInfo statCalculationInfo = possibleValues.statType().getStatCalculationInfo(possibleValues.baseValue());
        double lowerRawRollBound = (double)(value * 100 - 50) / (double)baseValue;
        double higherRawRollBound = (double)(value * 100 + 49) / (double)baseValue;
        if (baseValue < 0) {
            double temp = lowerRawRollBound;
            lowerRawRollBound = higherRawRollBound;
            higherRawRollBound = temp;
        }
        int starMin = statCalculationInfo.range().low();
        int starMax = statCalculationInfo.range().high();
        if (stars != -1 && statCalculationInfo.starInternalRollRanges().size() > stars) {
            RangedValue rangedValue = statCalculationInfo.starInternalRollRanges().get(stars);
            starMin = rangedValue.low();
            starMax = rangedValue.high();
        }
        int lowerRollBound = (int)Math.max(Math.ceil(lowerRawRollBound), (double)starMin);
        int higherRollBound = (int)Math.max((double)lowerRollBound, Math.min(Math.floor(higherRawRollBound), (double)starMax));
        return RangedValue.of(lowerRollBound, higherRollBound);
    }

    public static int calculateStarsFromInternalRoll(StatType statType, int baseValue, int internalRoll) {
        StatCalculationInfo statCalculationInfo = statType.getStatCalculationInfo(baseValue);
        if (baseValue < 0 && statType.treatAsInverted()) {
            statCalculationInfo = statType.getStatCalculationInfo(-baseValue);
        }
        for (int stars = 0; stars < statCalculationInfo.starInternalRollRanges().size(); ++stars) {
            RangedValue rangedValue = statCalculationInfo.starInternalRollRanges().get(stars);
            if (!rangedValue.inRange(internalRoll)) continue;
            return stars;
        }
        return 0;
    }

    public static int calculateStatValue(int internalRoll, StatPossibleValues possibleValues) {
        StatCalculationInfo statCalculationInfo = possibleValues.statType().getStatCalculationInfo(possibleValues.baseValue());
        RoundingMode roundingMode = statCalculationInfo.roundingMode();
        int value = new BigDecimal(possibleValues.baseValue()).multiply(BigDecimal.valueOf(internalRoll)).divide(BigDecimal.valueOf(100L), roundingMode).setScale(0, roundingMode).intValue();
        if (value == 0) {
            value = (int)Math.signum(possibleValues.baseValue());
        }
        return value;
    }

    public static Pair<Integer, Integer> getDisplayRange(StatPossibleValues possibleValues, boolean showBestValueLastAlways) {
        int last;
        int first;
        boolean isGood;
        StatType statType = possibleValues.statType();
        RangedValue valueRange = possibleValues.range();
        boolean bl = isGood = valueRange.low() > 0;
        if (showBestValueLastAlways || isGood) {
            first = valueRange.low();
            last = valueRange.high();
        } else {
            first = valueRange.high();
            last = valueRange.low();
        }
        if (statType.calculateAsInverted()) {
            first = -first;
            last = -last;
        }
        Pair<Integer, Integer> displayRange = Pair.of(first, last);
        return displayRange;
    }

    public static float getPercentage(StatActualValue actualValue, StatPossibleValues possibleValues) {
        int min = possibleValues.range().low();
        int max = possibleValues.range().high();
        if (actualValue.statType().treatAsInverted()) {
            return 100.0f - MathUtils.inverseLerp(min, max, actualValue.value()) * 100.0f;
        }
        return MathUtils.inverseLerp(min, max, actualValue.value()) * 100.0f;
    }

    public static double getPerfectChance(StatPossibleValues possibleValues) {
        StatCalculationInfo statCalculationInfo = possibleValues.statType().getStatCalculationInfo(possibleValues.baseValue());
        boolean treatAsNegative = possibleValues.statType().treatAsInverted() ^ possibleValues.baseValue() < 0;
        int allCases = statCalculationInfo.range().high() - statCalculationInfo.range().low() + 1;
        RangedValue perfectInternalRollRange = StatCalculator.calculateInternalRollRange(possibleValues, treatAsNegative ? possibleValues.range().low() : possibleValues.range().high(), -1);
        int perfectCases = perfectInternalRollRange.high() - perfectInternalRollRange.low() + 1;
        return (double)perfectCases / (double)allCases * 100.0;
    }

    public static double getDecreaseChance(StatActualValue actualValue, StatPossibleValues possibleValues) {
        assert (!possibleValues.range().isFixed());
        StatCalculationInfo statCalculationInfo = possibleValues.statType().getStatCalculationInfo(possibleValues.baseValue());
        boolean treatAsNegative = possibleValues.statType().treatAsInverted() ^ possibleValues.baseValue() < 0;
        RangedValue internalRollRange = actualValue.internalRoll();
        int allCases = statCalculationInfo.range().high() - statCalculationInfo.range().low() + 1;
        int decreaseCases = treatAsNegative ? statCalculationInfo.range().high() - internalRollRange.high() : internalRollRange.low() - statCalculationInfo.range().low();
        return (double)decreaseCases / (double)allCases * 100.0;
    }

    public static double getIncreaseChance(StatActualValue actualValue, StatPossibleValues possibleValues) {
        assert (!possibleValues.range().isFixed());
        StatCalculationInfo statCalculationInfo = possibleValues.statType().getStatCalculationInfo(possibleValues.baseValue());
        boolean treatAsNegative = possibleValues.statType().treatAsInverted() ^ possibleValues.baseValue() < 0;
        RangedValue internalRollRange = actualValue.internalRoll();
        int allCases = statCalculationInfo.range().high() - statCalculationInfo.range().low() + 1;
        int increaseCases = treatAsNegative ? internalRollRange.low() - statCalculationInfo.range().low() : statCalculationInfo.range().high() - internalRollRange.high();
        return (double)increaseCases / (double)allCases * 100.0;
    }

    public static Optional<Float> calculateOverallQuality(String itemName, List<StatPossibleValues> possibleValuesList, List<StatActualValue> identifications) {
        DoubleSummaryStatistics percents = identifications.stream().filter(actualValue -> {
            StatPossibleValues possibleValues = possibleValuesList.stream().filter(possibleValue -> possibleValue.statType().equals(actualValue.statType())).findFirst().orElse(null);
            if (possibleValues == null) {
                WynntilsMod.warn("Error:" + itemName + " claims to have identification " + String.valueOf(actualValue.statType()));
                return false;
            }
            return !possibleValues.range().isFixed() && possibleValues.range().inRange(actualValue.value());
        }).mapToDouble(actualValue -> {
            StatPossibleValues possibleValues = possibleValuesList.stream().filter(possibleValue -> possibleValue.statType().equals(actualValue.statType())).findFirst().orElse(null);
            return StatCalculator.getPercentage(actualValue, possibleValues);
        }).summaryStatistics();
        if (percents.getCount() == 0L) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf((float)percents.getAverage()));
    }

    private static void verifyCalculatedInternalRoll(int baseValue, StatCalculationInfo statCalculationInfo, int lowerRollBound, int higherRollBound, int starMin, int starMax) {
        assert (lowerRollBound <= higherRollBound);
        long lowerValue = new BigDecimal(baseValue).multiply(BigDecimal.valueOf(lowerRollBound)).divide(BigDecimal.valueOf(100L), statCalculationInfo.roundingMode()).setScale(0, statCalculationInfo.roundingMode()).longValue();
        long higherValue = new BigDecimal(baseValue).multiply(BigDecimal.valueOf(higherRollBound)).divide(BigDecimal.valueOf(100L), statCalculationInfo.roundingMode()).setScale(0, statCalculationInfo.roundingMode()).longValue();
        assert (lowerValue == higherValue);
        long oneBelowLowerValue = new BigDecimal(baseValue).multiply(BigDecimal.valueOf(lowerRollBound - 1)).divide(BigDecimal.valueOf(100L), statCalculationInfo.roundingMode()).setScale(0, statCalculationInfo.roundingMode()).longValue();
        assert (lowerRollBound == starMin || lowerValue != oneBelowLowerValue);
        long oneAboveHigherValue = new BigDecimal(baseValue).multiply(BigDecimal.valueOf(higherRollBound + 1)).divide(BigDecimal.valueOf(100L), statCalculationInfo.roundingMode()).setScale(0, statCalculationInfo.roundingMode()).longValue();
        assert (higherRollBound == starMax || higherValue != oneAboveHigherValue);
    }
}

