/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.statuseffects.type;

import com.google.common.collect.ComparisonChain;
import com.wynntils.core.text.StyledText;

public class StatusEffect
implements Comparable<StatusEffect> {
    private final StyledText fullName;
    private final StyledText name;
    private final StyledText modifier;
    private final StyledText modifierSuffix;
    private final Double modifierValue;
    private final int duration;
    private StyledText displayedTime;
    private StyledText prefix;

    public StatusEffect(StyledText name, StyledText modifier, StyledText modifierSuffix, StyledText displayedTime, StyledText prefix, int duration) {
        this.name = name;
        this.displayedTime = displayedTime;
        this.prefix = prefix;
        this.modifier = modifier;
        this.modifierSuffix = modifierSuffix;
        this.fullName = StyledText.concat(prefix, StyledText.fromString(" "), modifier, modifierSuffix, StyledText.fromString(" "), name, StyledText.fromString(" "), displayedTime);
        this.modifierValue = modifier == StyledText.EMPTY ? null : Double.valueOf(Double.parseDouble(modifier.getStringWithoutFormatting()));
        this.duration = duration;
    }

    public StyledText getName() {
        return this.name;
    }

    public StyledText getModifier() {
        return this.modifier;
    }

    public StyledText getDisplayedTime() {
        return this.displayedTime;
    }

    public void setDisplayedTime(StyledText displayedTime) {
        this.displayedTime = displayedTime;
    }

    public StyledText getPrefix() {
        return this.prefix;
    }

    public void setPrefix(StyledText prefix) {
        this.prefix = prefix;
    }

    public StyledText asString() {
        return this.fullName;
    }

    public StyledText getModifierSuffix() {
        return this.modifierSuffix;
    }

    public boolean hasModifierValue() {
        return this.modifierValue != null;
    }

    public double getModifierValue() {
        return this.modifierValue;
    }

    public int getDuration() {
        return this.duration;
    }

    @Override
    public int compareTo(StatusEffect effect) {
        return ComparisonChain.start().compare((Comparable)((Object)this.getPrefix().getString()), (Comparable)((Object)effect.getPrefix().getString())).compare((Comparable)((Object)this.getName().getString()), (Comparable)((Object)effect.getName().getString())).compare((Comparable)((Object)this.getModifier().getString()), (Comparable)((Object)effect.getModifier().getString())).result();
    }
}

