/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.token.type;

import com.wynntils.core.text.StyledText;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.type.CappedValue;
import java.util.Objects;

public final class TokenGatekeeper
implements Comparable<TokenGatekeeper> {
    private final StyledText gatekeeperTokenName;
    private final StyledText itemTokenName;
    private final Location location;
    private CappedValue deposited;

    public TokenGatekeeper(StyledText gatekeeperTokenName, Location location, CappedValue deposited) {
        this.gatekeeperTokenName = gatekeeperTokenName;
        this.itemTokenName = gatekeeperTokenName.replaceAll("s$", "");
        this.location = location;
        this.deposited = deposited;
    }

    public TokenGatekeeper(StyledText gatekeeperTokenName, StyledText itemTokenName, Location location, CappedValue deposited) {
        this.gatekeeperTokenName = gatekeeperTokenName;
        this.itemTokenName = itemTokenName;
        this.location = location;
        this.deposited = deposited;
    }

    public StyledText getGatekeeperTokenName() {
        return this.gatekeeperTokenName;
    }

    public StyledText getItemTokenName() {
        return this.itemTokenName;
    }

    public CappedValue getDeposited() {
        return this.deposited;
    }

    public void setDeposited(CappedValue value) {
        this.deposited = value;
    }

    private Location getLocation() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenGatekeeper that = (TokenGatekeeper)o;
        return Objects.equals(this.gatekeeperTokenName, that.gatekeeperTokenName) && Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(this.gatekeeperTokenName, this.location);
    }

    public String toString() {
        return "TokenGatekeeper{type='" + String.valueOf(this.gatekeeperTokenName) + "', location=" + String.valueOf(this.location) + ", deposited=" + String.valueOf(this.deposited) + "}";
    }

    @Override
    public int compareTo(TokenGatekeeper that) {
        return this.getLocation().compareTo(that.getLocation());
    }
}

