/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.worlds;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.bossbar.TrackedBar;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.models.worlds.bossbars.InfoBar;
import com.wynntils.models.worlds.event.BombEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.BombInfo;
import com.wynntils.models.worlds.type.BombSortOrder;
import com.wynntils.models.worlds.type.BombType;
import com.wynntils.utils.mc.StyledTextUtils;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

public final class BombModel
extends Model {
    private static final TrackedBar InfoBar = new InfoBar();
    private static final Pattern BOMB_BELL_PATTERN = Pattern.compile("^\u00a7#fddd5cff(?:\ue01e\ue002|\ue001) (?<user>.+) has thrown an? \u00a7#f3e6b2ff(?<bomb>.+) Bomb\u00a7#fddd5cff on \u00a7#f3e6b2ff\u00a7n(?<server>.+)$");
    private static final Pattern BOMB_EXPIRED_PATTERN = Pattern.compile("^\u00a7#a0c84bff(?:\ue014\ue002|\ue001) \u00a7#ffd750ff.+\u00a7#a0c84bff (?<bomb>.+) Bomb has expired!.*$");
    private static final Pattern BOMB_THROWN_PATTERN = Pattern.compile("^\u00a7#a0c84bff(?:\ue014\ue002|\ue001) \u00a7l(?<bomb>.+) Bomb$");
    private static final Map<BombType, BombInfo> CURRENT_SERVER_BOMBS = new EnumMap<BombType, BombInfo>(BombType.class);
    private static final ActiveBombContainer BOMBS = new ActiveBombContainer();

    public BombModel() {
        super(List.of());
        Handlers.BossBar.registerBar(InfoBar);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChat(ChatMessageEvent.Match event) {
        StyledText message = event.getMessage();
        StyledText unwrapped = StyledTextUtils.unwrap(event.getMessage()).stripAlignment();
        Matcher bellMatcher = unwrapped.getMatcher(BOMB_BELL_PATTERN);
        if (bellMatcher.matches()) {
            BombInfo bombInfo = this.addBombFromChat(bellMatcher.group("user"), bellMatcher.group("bomb"), bellMatcher.group("server").trim());
            if (bombInfo == null) {
                return;
            }
            BombEvent.BombBell bombEvent = new BombEvent.BombBell(bombInfo, message);
            WynntilsMod.postEvent(bombEvent);
            return;
        }
        Matcher localMatcher = unwrapped.getMatcher(BOMB_THROWN_PATTERN);
        if (localMatcher.matches()) {
            BombInfo bombInfo = this.addBombFromChat("", localMatcher.group("bomb"), Models.WorldState.getCurrentWorldName());
            if (bombInfo == null) {
                return;
            }
            BombEvent.Local bombEvent = new BombEvent.Local(bombInfo, message);
            WynntilsMod.postEvent(bombEvent);
            return;
        }
        Matcher expiredMatcher = unwrapped.getMatcher(BOMB_EXPIRED_PATTERN);
        if (expiredMatcher.matches()) {
            String bomb = expiredMatcher.group("bomb");
            this.removeOldTimers();
            BombType bombType = BombType.fromString(bomb);
            if (bombType == null) {
                return;
            }
            BombInfo removed = CURRENT_SERVER_BOMBS.remove((Object)bombType);
            if (removed == null) {
                return;
            }
            BOMBS.remove(removed);
        }
    }

    private BombInfo addBombFromChat(String user, String bomb, String server) {
        this.removeOldTimers();
        BombType bombType = BombType.fromString(bomb);
        if (bombType == null) {
            return null;
        }
        return BOMBS.forceAdd(new BombInfo(user, bombType, server, System.currentTimeMillis(), bombType.getActiveMinutes()));
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        CURRENT_SERVER_BOMBS.clear();
    }

    public void addBombInfoFromInfoBar(BombInfo bombInfo) {
        CURRENT_SERVER_BOMBS.put(bombInfo.bomb(), bombInfo);
        BOMBS.add(bombInfo);
        WynntilsMod.postEvent(new BombEvent.Local(bombInfo, null));
    }

    public boolean isBombActive(BombType bombType) {
        return CURRENT_SERVER_BOMBS.containsKey((Object)bombType) && CURRENT_SERVER_BOMBS.get((Object)bombType).isActive();
    }

    private void removeOldTimers() {
        BOMBS.removeIf(bombInfo -> !bombInfo.isActive());
    }

    public Set<BombInfo> getBombBells() {
        this.removeOldTimers();
        return BOMBS.asSet();
    }

    public Stream<BombInfo> getBombBellStream(boolean group, BombSortOrder sortOrder) {
        return this.getBombBellStream(group, sortOrder, this.getBombBells().size());
    }

    public Stream<BombInfo> getBombBellStream(boolean group, BombSortOrder sortOrder, int maxPerGroup) {
        Comparator<BombInfo> comparator;
        Stream stream = this.getBombBells().stream();
        Comparator<BombInfo> comparator2 = comparator = sortOrder == BombSortOrder.NEWEST ? Comparator.comparing(BombInfo::getRemainingLong).reversed() : Comparator.comparing(BombInfo::getRemainingLong);
        if (group) {
            return stream.collect(Collectors.groupingBy(BombInfo::bomb)).values().stream().flatMap(list -> list.stream().sorted(comparator).limit(maxPerGroup));
        }
        return stream.sorted(comparator).limit(maxPerGroup);
    }

    public BombInfo getLastBomb() {
        return BOMBS.getLastBomb();
    }

    public void addDummyBombInfo() {
        BOMBS.forceAdd(new BombInfo("Wanytails", BombType.COMBAT_XP, "EU052", System.currentTimeMillis(), 1.0f));
        BOMBS.forceAdd(new BombInfo("Wanytails", BombType.PROFESSION_SPEED, "EU052", System.currentTimeMillis(), 1.2f));
        BOMBS.forceAdd(new BombInfo("Wyntil", BombType.PROFESSION_SPEED, "US152", System.currentTimeMillis(), 0.8f));
        BOMBS.forceAdd(new BombInfo("Wyntil", BombType.DUNGEON, "EU152", System.currentTimeMillis(), 0.6f));
        BOMBS.forceAdd(new BombInfo("Player 0", BombType.PROFESSION_XP, "AS558", System.currentTimeMillis(), 1.0f));
        BOMBS.forceAdd(new BombInfo("Player 0", BombType.COMBAT_XP, "AS558", System.currentTimeMillis(), 0.5f));
    }

    private static final class ActiveBombContainer {
        private final Map<BombKey, BombInfo> bombs = new ConcurrentHashMap<BombKey, BombInfo>();

        private ActiveBombContainer() {
        }

        public BombInfo add(BombInfo bombInfo) {
            return this.add(bombInfo, false);
        }

        public BombInfo forceAdd(BombInfo bombInfo) {
            return this.add(bombInfo, true);
        }

        private BombInfo add(BombInfo bombInfo, boolean replaceIfExists) {
            BombKey key = new BombKey(bombInfo.server(), bombInfo.bomb());
            if (this.bombs.containsKey(key) && !replaceIfExists) {
                return this.bombs.get(key);
            }
            this.bombs.put(key, bombInfo);
            return bombInfo;
        }

        public Set<BombInfo> asSet() {
            return Set.copyOf(this.bombs.values());
        }

        public void removeIf(Predicate<BombInfo> predicate) {
            this.bombs.entrySet().removeIf((? super E entry) -> predicate.test((BombInfo)entry.getValue()));
        }

        public void remove(BombInfo removed) {
            this.bombs.remove(new BombKey(removed.server(), removed.bomb()));
        }

        public BombInfo getLastBomb() {
            return this.bombs.values().stream().max(Comparator.comparingLong(BombInfo::startTime)).orElse(null);
        }
    }

    private record BombKey(String server, BombType type) {
    }
}

