/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.wynnitem;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Model;
import com.wynntils.core.net.DownloadRegistry;
import com.wynntils.core.net.UrlId;
import com.wynntils.models.festival.type.FestivalType;
import com.wynntils.models.wynnitem.type.ItemObtainInfo;
import com.wynntils.models.wynnitem.type.ItemObtainType;
import com.wynntils.models.wynnitem.type.MaterialConversionInfo;
import com.wynntils.utils.JsonUtils;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public final class WynnItemModel
extends Model {
    private Map<String, List<ItemObtainInfo>> itemObtainMap = Map.of();
    private List<MaterialConversionInfo> allMaterialConversions = List.of();
    private Map<Integer, MaterialConversionInfo> materialConversionLookup = Map.of();

    public WynnItemModel() {
        super(List.of());
    }

    @Override
    public void registerDownloads(DownloadRegistry registry) {
        registry.registerDownload(UrlId.DATA_STATIC_ITEM_OBTAIN_V2).handleReader(this::handleObtainData);
        registry.registerDownload(UrlId.DATA_STATIC_MATERIAL_CONVERSION).handleReader(this::handleMaterialConversionData);
    }

    public List<ItemObtainInfo> getObtainInfo(String name) {
        return this.itemObtainMap.getOrDefault(name, List.of());
    }

    public Optional<String> getMaterialName(int idCode, int damageCode) {
        MaterialConversionInfo conversionInfo = this.allMaterialConversions.stream().filter(c -> c.id() == idCode && c.type() == damageCode).findFirst().orElse(null);
        if (conversionInfo == null) {
            return Optional.empty();
        }
        return Optional.of(conversionInfo.name());
    }

    private void handleObtainData(Reader reader) {
        Type obtainType = new TypeToken<Map<String, List<ItemObtainInfo>>>(){}.getType();
        Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(ItemObtainInfo.class, (Object)new ItemObtainInfoDeserializer()).create();
        this.itemObtainMap = (Map)gson.fromJson(reader, obtainType);
    }

    private void handleMaterialConversionData(Reader reader) {
        Type materialConversionType = new TypeToken<List<MaterialConversionInfo>>(){}.getType();
        this.allMaterialConversions = (List)WynntilsMod.GSON.fromJson(reader, materialConversionType);
        HashMap<Integer, MaterialConversionInfo> lookupMap = new HashMap<Integer, MaterialConversionInfo>();
        this.allMaterialConversions.forEach(m -> lookupMap.put(m.id(), (MaterialConversionInfo)m));
        this.materialConversionLookup = lookupMap;
    }

    public boolean hasObtainInfo() {
        return !this.itemObtainMap.isEmpty();
    }

    public boolean hasMaterialConversionInfo() {
        return !this.allMaterialConversions.isEmpty();
    }

    private static final class ItemObtainInfoDeserializer
    implements JsonDeserializer<ItemObtainInfo> {
        private ItemObtainInfoDeserializer() {
        }

        public ItemObtainInfo deserialize(JsonElement jsonElement, Type jsonType, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = jsonElement.getAsJsonObject();
            String sourceTypeStr = json.get("type").getAsString();
            ItemObtainType sourceType = ItemObtainType.fromApiName(sourceTypeStr);
            String name = JsonUtils.getNullableJsonString(json, "name");
            if (sourceType == null) {
                WynntilsMod.warn("Unknown item obtain type: " + sourceTypeStr);
                sourceType = ItemObtainType.UNKNOWN;
            } else if (sourceType == ItemObtainType.EVENT && name != null) {
                FestivalType festivalType = FestivalType.valueOf(name.toUpperCase(Locale.ROOT));
                return new ItemObtainInfo(ItemObtainType.EVENT, Optional.of(festivalType.getFullName()));
            }
            return new ItemObtainInfo(sourceType, Optional.ofNullable(name));
        }
    }
}

