/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.class_1041;
import net.minecraft.class_1268;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_9779;

public class HeldItemCooldownOverlay
extends Overlay {
    public HeldItemCooldownOverlay() {
        super(new OverlayPosition(0.0f, 0.0f, VerticalAlignment.MIDDLE, HorizontalAlignment.CENTER, OverlayPosition.AnchorSection.MIDDLE), new OverlaySize(80.0f, 14.0f));
        this.userEnabled.store(false);
    }

    @Override
    public void render(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        class_746 player = McUtils.player();
        float cooldownPercent = player.method_7357().method_7905(player.method_5998(class_1268.field_5808), deltaTracker.method_60637(true));
        if (cooldownPercent <= 0.0f) {
            return;
        }
        this.renderOverlay(guiGraphics.method_51448(), bufferSource, cooldownPercent);
    }

    @Override
    public void renderPreview(class_332 guiGraphics, class_4597 bufferSource, class_9779 deltaTracker, class_1041 window) {
        this.renderOverlay(guiGraphics.method_51448(), bufferSource, 1.0f);
    }

    private void renderOverlay(class_4587 poseStack, class_4597 bufferSource, float cooldownPercent) {
        float width = this.getWidth();
        float x1 = this.getRenderX();
        float x2 = x1 + width;
        float height = this.getHeight();
        float y = this.getRenderY();
        CustomColor color = CommonColors.WHITE;
        float ym = y + height / 2.0f;
        BufferedRenderUtils.drawLine(poseStack, bufferSource, color, x1, ym, x1 + width * 0.4f, ym, 0.0f, 1.0f);
        BufferedRenderUtils.drawLine(poseStack, bufferSource, color, x2 - width * 0.4f, ym, x2, ym, 0.0f, 1.0f);
        float barWidth = 3.0f;
        float offset = (1.0f - cooldownPercent) * (width - barWidth) / 2.0f;
        BufferedRenderUtils.drawRect(poseStack, bufferSource, color, x1 + offset, y, 0.0f, barWidth, height);
        BufferedRenderUtils.drawRect(poseStack, bufferSource, color, x2 - barWidth - offset, y, 0.0f, barWidth, height);
    }
}

