/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.consumers.overlays.TextOverlay;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.ColorChatFormatting;
import com.wynntils.utils.mc.RenderedStringUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_124;

public class ShamanTotemTimerOverlay
extends TextOverlay {
    @Persisted
    private final Config<TotemTrackingDetail> totemTrackingDetail = new Config<TotemTrackingDetail>(TotemTrackingDetail.COORDS);
    @Persisted
    private final Config<ColorChatFormatting> firstTotemTextColor = new Config<ColorChatFormatting>(ColorChatFormatting.WHITE);
    @Persisted
    private final Config<ColorChatFormatting> secondTotemTextColor = new Config<ColorChatFormatting>(ColorChatFormatting.BLUE);
    @Persisted
    private final Config<ColorChatFormatting> thirdTotemTextColor = new Config<ColorChatFormatting>(ColorChatFormatting.RED);
    @Persisted
    private final Config<ColorChatFormatting> fourthTotemTextColor = new Config<ColorChatFormatting>(ColorChatFormatting.GREEN);
    private final class_124[] totemColorsArray = new class_124[]{((ColorChatFormatting)((Object)this.firstTotemTextColor.get())).getChatFormatting(), ((ColorChatFormatting)((Object)this.secondTotemTextColor.get())).getChatFormatting(), ((ColorChatFormatting)((Object)this.thirdTotemTextColor.get())).getChatFormatting(), ((ColorChatFormatting)((Object)this.fourthTotemTextColor.get())).getChatFormatting()};

    public ShamanTotemTimerOverlay() {
        super(new OverlayPosition(275.0f, -5.0f, VerticalAlignment.TOP, HorizontalAlignment.RIGHT, OverlayPosition.AnchorSection.TOP_RIGHT), new OverlaySize(120.0f, 35.0f));
    }

    @Override
    public String getTemplate() {
        return Models.ShamanTotem.getActiveTotems().stream().filter(Objects::nonNull).map(totem -> String.valueOf(this.totemColorsArray[totem.getTotemNumber() - 1]) + ((TotemTrackingDetail)((Object)((Object)this.totemTrackingDetail.get()))).getTemplate().replaceAll("%d", String.valueOf(totem.getTotemNumber()))).collect(Collectors.joining("\n"));
    }

    @Override
    public String getPreviewTemplate() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < TotemTrackingDetail.values().length; ++i) {
            builder.append(this.totemColorsArray[i]).append(TotemTrackingDetail.values()[i].getPreviewTemplate()).append("\n");
        }
        return builder.toString();
    }

    @Override
    protected StyledText[] calculateTemplateValue(String template) {
        return (StyledText[])Arrays.stream(super.calculateTemplateValue(template)).map(s -> RenderedStringUtils.trySplitOptimally(s, this.getWidth())).map(s -> s.split("\n")).flatMap(Arrays::stream).toArray(StyledText[]::new);
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        this.totemColorsArray[0] = ((ColorChatFormatting)((Object)this.firstTotemTextColor.get())).getChatFormatting();
        this.totemColorsArray[1] = ((ColorChatFormatting)((Object)this.secondTotemTextColor.get())).getChatFormatting();
        this.totemColorsArray[2] = ((ColorChatFormatting)((Object)this.thirdTotemTextColor.get())).getChatFormatting();
        this.totemColorsArray[3] = ((ColorChatFormatting)((Object)this.fourthTotemTextColor.get())).getChatFormatting();
    }

    private static enum TotemTrackingDetail {
        NONE("{IF_STR(EQ_STR(SHAMAN_TOTEM_STATE(%d); \"ACTIVE\"); CONCAT(\"Totem %d (\"; STRING(SHAMAN_TOTEM_TIME_LEFT(%d));\" s)\"); IF_STR(EQ_STR(SHAMAN_TOTEM_STATE(%d); \"SUMMONED\"); \"Totem %d summoned\"; \"\"))}", "Totem 1 (10 s)"),
        COORDS("{IF_STR(EQ_STR(SHAMAN_TOTEM_STATE(%d); \"ACTIVE\"); CONCAT(\"Totem %d (\"; STRING(SHAMAN_TOTEM_TIME_LEFT(%d));\" s)\"; \" \"; SHAMAN_TOTEM_LOCATION(%d)); IF_STR(EQ_STR(SHAMAN_TOTEM_STATE(%d); \"SUMMONED\"); \"Totem %d summoned\"; \"\"))}", "Totem 2 (15 s) [1425, 12, 512]"),
        DISTANCE("{IF_STR(EQ_STR(SHAMAN_TOTEM_STATE(%d); \"ACTIVE\"); CONCAT(\"Totem %d (\"; STRING(SHAMAN_TOTEM_TIME_LEFT(%d));\" s, \"; STRING(INT(SHAMAN_TOTEM_DISTANCE(%d))); \" m)\"); IF_STR(EQ_STR(SHAMAN_TOTEM_STATE(%d); \"SUMMONED\"); \"Totem %d summoned\"; \"\"))}", "Totem 3 (7s, 10 m)");

        private final String template;
        private final String previewTemplate;

        private TotemTrackingDetail(String template, String previewTemplate) {
            this.template = template;
            this.previewTemplate = previewTemplate;
        }

        private String getTemplate() {
            return this.template;
        }

        private String getPreviewTemplate() {
            return this.previewTemplate;
        }
    }
}

