/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.overlays.gamebars;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.overlays.OverlayPosition;
import com.wynntils.core.consumers.overlays.OverlaySize;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.handlers.bossbar.TrackedBar;
import com.wynntils.handlers.bossbar.type.BossBarProgress;
import com.wynntils.overlays.gamebars.OverflowableBarOverlay;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.ManaTexture;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.CappedValue;

public class ManaBarOverlay
extends OverflowableBarOverlay {
    @Persisted(i18nKey="overlay.wynntils.manaBar.manaTexture")
    private final Config<ManaTexture> manaTexture = new Config<ManaTexture>(ManaTexture.A);

    public ManaBarOverlay() {
        this(new OverlayPosition(-34.0f, 67.0f, VerticalAlignment.BOTTOM, HorizontalAlignment.CENTER, OverlayPosition.AnchorSection.BOTTOM_MIDDLE), new OverlaySize(81.0f, 21.0f));
    }

    protected ManaBarOverlay(OverlayPosition overlayPosition, OverlaySize overlaySize) {
        super(overlayPosition, overlaySize, CommonColors.LIGHT_BLUE);
        this.userEnabled.store(false);
    }

    @Override
    public float textureHeight() {
        return ((ManaTexture)this.manaTexture.get()).getHeight();
    }

    @Override
    public BossBarProgress progress() {
        CappedValue mana = Models.CharacterStats.getMana().orElse(CappedValue.EMPTY);
        return new BossBarProgress(mana, (float)mana.getProgress());
    }

    @Override
    protected Class<? extends TrackedBar> getTrackedBarClass() {
        return null;
    }

    @Override
    public String icon() {
        return "\u273a";
    }

    @Override
    public boolean isVisible() {
        return Models.CharacterStats.getMana().isPresent();
    }

    @Override
    protected void onConfigUpdate(Config<?> config) {
        Models.CharacterStats.setHideMana(Managers.Overlay.isEnabled(this) && (Boolean)this.shouldDisplayOriginal.get() == false);
    }

    @Override
    protected Texture getTexture() {
        return Texture.MANA_BAR;
    }

    @Override
    protected Texture getOverflowTexture() {
        return Texture.MANA_BAR_OVERFLOW;
    }

    @Override
    protected int getTextureY1() {
        return ((ManaTexture)this.manaTexture.get()).getTextureY1();
    }

    @Override
    protected int getTextureY2() {
        return ((ManaTexture)this.manaTexture.get()).getTextureY2();
    }
}

