/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.activities.widgets;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.activities.type.ActivityInfo;
import com.wynntils.models.activities.type.ActivityStatus;
import com.wynntils.models.activities.type.ActivityTrackingState;
import com.wynntils.models.activities.type.ActivityType;
import com.wynntils.screens.activities.ContentBookHolder;
import com.wynntils.screens.activities.WynntilsContentBookScreen;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_6382;

public class ContentBookWidget
extends class_339
implements TooltipProvider {
    private static final CustomColor UNAVAILABLE_COLOR = CustomColor.fromHexString("#AD976C");
    private final ContentBookHolder holder;
    private final ActivityInfo activityInfo;
    private final class_1799 itemStack;
    private final Integer slot;
    private final List<class_2561> tooltip;
    private final boolean searchMatch;
    private class_2583 nameStyle = class_2583.field_24360;

    public ContentBookWidget(int x, int y, Pair<class_1799, ActivityInfo> activityInfoPair, int slot, ContentBookHolder holder, boolean searchMatch) {
        super(x, y, 132, 16, (class_2561)class_2561.method_43470((String)"Content Book Activity Button"));
        this.itemStack = activityInfoPair.a();
        this.activityInfo = activityInfoPair.b();
        this.slot = slot;
        this.holder = holder;
        this.searchMatch = searchMatch;
        ArrayList<class_2561> addons = new ArrayList<class_2561>();
        addons.add((class_2561)class_2561.method_43473());
        if (this.canSetCompass()) {
            addons.add((class_2561)class_2561.method_43471((String)"screens.wynntils.contentBook.leftClickToSetCompass").method_27692(class_124.field_1067).method_27692(class_124.field_1060));
        }
        if (this.canOpenMap()) {
            addons.add((class_2561)class_2561.method_43471((String)"screens.wynntils.contentBook.middleClickToOpenOnMap").method_27692(class_124.field_1067).method_27692(class_124.field_1054));
        }
        addons.add((class_2561)class_2561.method_43471((String)"screens.wynntils.contentBook.rightClickToOpenWiki").method_27692(class_124.field_1067).method_27692(class_124.field_1065));
        this.tooltip = LoreUtils.appendTooltip(this.itemStack, LoreUtils.getTooltipLines(this.itemStack), addons);
        if (this.activityInfo.trackingState() == ActivityTrackingState.TRACKED) {
            this.nameStyle = this.nameStyle.method_10982(Boolean.valueOf(true)).method_30938(Boolean.valueOf(true));
        }
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        CustomColor gradientColor = this.activityInfo.status() == ActivityStatus.UNAVAILABLE ? UNAVAILABLE_COLOR : this.activityInfo.type().getColor();
        RenderUtils.fillSidewaysGradient(guiGraphics.method_51448(), this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0, gradientColor, gradientColor.withAlpha(0));
        guiGraphics.method_51427(this.itemStack, this.method_46426(), this.method_46427());
        this.nameStyle = this.nameStyle.method_10982(Boolean.valueOf(this.field_22762 || this.activityInfo.trackingState() == ActivityTrackingState.TRACKED));
        FontRenderer.getInstance().renderScrollingText(guiGraphics.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_43470((String)this.activityInfo.name()).method_27696(this.nameStyle)), this.method_46426() + 18, this.method_46427() + 8, this.field_22758 - 18, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        if (this.holder.inTutorial) {
            RenderUtils.drawRotatingBorderSegment(guiGraphics.method_51448(), CommonColors.RED, this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 1.0f, 2.0f, 0.25f);
        }
        if (this.searchMatch) {
            return;
        }
        RenderUtils.drawRect(guiGraphics.method_51448(), CommonColors.BLACK.withAlpha(100), this.method_46426(), this.method_46427(), 1.0f, this.field_22758, this.field_22759);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.canSetCompass()) {
                Models.Activity.placeCompassOnActivity(this.activityInfo);
            } else {
                class_437 class_4372;
                this.holder.pressSlot(this.slot);
                if (this.activityInfo.trackingState() == ActivityTrackingState.TRACKED && (class_4372 = McUtils.mc().field_1755) instanceof WynntilsContentBookScreen) {
                    WynntilsContentBookScreen contentBookScreen = (WynntilsContentBookScreen)class_4372;
                    contentBookScreen.removeTrackedActivity();
                }
            }
        } else if (button == 2 && this.canOpenMap()) {
            Models.Activity.openMapOnActivity(this.activityInfo);
        } else if (button == 1) {
            if (this.activityInfo.type() == ActivityType.WORLD_EVENT && this.activityInfo.status() == ActivityStatus.AVAILABLE && KeyboardUtils.isShiftDown()) {
                this.holder.pressSlot(this.slot, button);
            } else {
                Models.Activity.openActivityOnWiki(this.activityInfo);
            }
        }
        return true;
    }

    @Override
    public List<class_2561> getTooltipLines() {
        return Collections.unmodifiableList(this.tooltip);
    }

    private boolean canSetCompass() {
        return switch (this.activityInfo.type()) {
            case ActivityType.SECRET_DISCOVERY -> true;
            case ActivityType.WORLD_DISCOVERY, ActivityType.TERRITORIAL_DISCOVERY, ActivityType.BOSS_ALTAR -> {
                if (this.activityInfo.status() != ActivityStatus.AVAILABLE && this.activityInfo.trackingState() != ActivityTrackingState.TRACKED) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean canOpenMap() {
        return switch (this.activityInfo.type()) {
            case ActivityType.QUEST, ActivityType.STORYLINE_QUEST -> {
                if (this.activityInfo.status() == ActivityStatus.STARTED || this.activityInfo.status() == ActivityStatus.AVAILABLE) {
                    yield true;
                }
                yield false;
            }
            case ActivityType.MINI_QUEST -> {
                if (this.activityInfo.status() != ActivityStatus.COMPLETED && this.activityInfo.trackingState() != ActivityTrackingState.UNTRACKABLE) {
                    yield true;
                }
                yield false;
            }
            case ActivityType.WORLD_EVENT -> false;
            default -> true;
        };
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

