/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.base.widgets;

import com.google.common.collect.Lists;
import com.wynntils.core.components.Services;
import com.wynntils.screens.base.widgets.BasicTexturedButton;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.StatFilter;
import com.wynntils.services.itemfilter.type.StatFilterFactory;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class ItemSearchHelperWidget
extends BasicTexturedButton {
    private static final int ELEMENTS_PER_PAGE = 4;
    private final List<ItemProviderType> supportedProviderTypes;
    private final List<List<class_2561>> tooltipPages = new ArrayList<List<class_2561>>();
    private int page = 0;

    public ItemSearchHelperWidget(int x, int y, int width, int height, Texture texture, boolean scaleTexture, List<ItemProviderType> supportedProviderTypes) {
        super(x, y, width, height, texture, b -> {}, List.of(), scaleTexture);
        this.supportedProviderTypes = supportedProviderTypes;
        this.generateTooltipPages();
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.drawTexturedRectWithColor(guiGraphics.method_51448(), Texture.INFO.resource(), this.field_22762 ? CommonColors.AQUA : CommonColors.WHITE, this.method_46426(), this.method_46427(), 0.0f, this.method_25368(), this.method_25364(), 0, 0, Texture.INFO.width(), Texture.INFO.height(), Texture.INFO.width(), Texture.INFO.height());
        if (this.field_22762) {
            McUtils.mc().field_1755.method_47414(Lists.transform(this.getTooltipLines(), class_2561::method_30937));
        }
    }

    @Override
    public List<class_2561> getTooltipLines() {
        return this.tooltipPages.get(this.page);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        if (button == 0) {
            this.page = MathUtils.overflowInRange(this.page, -1, 0, this.tooltipPages.size() - 1);
            return true;
        }
        if (button == 1) {
            this.page = MathUtils.overflowInRange(this.page, 1, 0, this.tooltipPages.size() - 1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void generateTooltipPages() {
        void var6_9;
        ArrayList<class_5250> currentTooltip = new ArrayList<class_5250>();
        int counter = 0;
        int filterPageCount = 0;
        List<StatFilterFactory<StatFilter<?>>> statFilters = Services.ItemFilter.getStatFilters();
        for (StatFilterFactory<StatFilter<?>> statFilterFactory : statFilters) {
            currentTooltip.add(class_2561.method_43473());
            currentTooltip.add(class_2561.method_43470((String)(statFilterFactory.getTranslatedName() + ": ")).method_27692(class_124.field_1054));
            currentTooltip.add(class_2561.method_43471((String)statFilterFactory.getDescription()).method_27692(class_124.field_1080));
            currentTooltip.add(class_2561.method_43471((String)statFilterFactory.getUsage()).method_27692(class_124.field_1080));
            if (++counter != 4) continue;
            this.tooltipPages.add(currentTooltip);
            currentTooltip = new ArrayList();
            counter = 0;
            ++filterPageCount;
        }
        if (counter != 0) {
            this.tooltipPages.add(currentTooltip);
            currentTooltip = new ArrayList();
            ++filterPageCount;
        }
        counter = 0;
        List<ItemStatProvider> itemStatProviders = Services.ItemFilter.getItemStatProviders().stream().filter(itemStatProvider -> itemStatProvider.getFilterTypes().stream().anyMatch(this.supportedProviderTypes::contains)).toList();
        for (ItemStatProvider itemStatProvider2 : itemStatProviders) {
            currentTooltip.add(class_2561.method_43473());
            currentTooltip.add(class_2561.method_43470((String)(itemStatProvider2.getName() + ": ")).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)("(" + itemStatProvider2.getType().getSimpleName() + ")")).method_27692(class_124.field_1080)));
            currentTooltip.add(class_2561.method_43471((String)itemStatProvider2.getDescription()).method_27692(class_124.field_1080));
            if (++counter != 4) continue;
            this.tooltipPages.add(currentTooltip);
            currentTooltip = new ArrayList();
            counter = 0;
        }
        if (counter != 0) {
            this.tooltipPages.add(currentTooltip);
        }
        boolean bl = false;
        while (var6_9 < this.tooltipPages.size()) {
            List<class_2561> tooltipPage2 = this.tooltipPages.get((int)var6_9);
            if (var6_9 < filterPageCount) {
                tooltipPage2.addFirst((class_2561)class_2561.method_43471((String)"screens.wynntils.itemSearchHelperWidget.availableFilters"));
            } else {
                tooltipPage2.addFirst((class_2561)class_2561.method_43471((String)"screens.wynntils.itemSearchHelperWidget.availableStats"));
            }
            tooltipPage2.add((class_2561)class_2561.method_43473());
            tooltipPage2.add((class_2561)class_2561.method_43469((String)"screens.wynntils.itemSearchHelperWidget.page", (Object[])new Object[]{(int)(var6_9 + true), this.tooltipPages.size()}).method_27692(class_124.field_1080).method_27692(class_124.field_1067));
            tooltipPage2.add((class_2561)class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.itemSearchHelperWidget.switchPage").method_27693(")")).method_27692(class_124.field_1080));
            ++var6_9;
        }
        this.tooltipPages.replaceAll(tooltipPage -> ComponentUtils.wrapTooltips(tooltipPage, 200));
    }
}

