/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.changelog;

import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.WynntilsPagedScreen;
import com.wynntils.screens.base.widgets.PageSelectorButton;
import com.wynntils.screens.changelog.widgets.ExitFlagButton;
import com.wynntils.services.athena.type.ChangelogMap;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.TextRenderSetting;
import com.wynntils.utils.render.TextRenderTask;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public final class ChangelogScreen
extends WynntilsScreen
implements WynntilsPagedScreen {
    private static final float SCROLL_FACTOR = 10.0f;
    private static final int SCISSOR_HEIGHT = 165;
    private static final int SCROLLBAR_RENDER_X = 268;
    private static final int SCROLL_AREA_HEIGHT = 120;
    private static final int SCROLLBAR_HEIGHT = 20;
    private static final int SCROLLBAR_WIDTH = 6;
    private final ChangelogMap changelog;
    private final class_437 previousScreen;
    private List<List<TextRenderTask>> changelogTasks;
    private boolean draggingScroll = false;
    private int currentPage = 0;
    private int offsetX;
    private int offsetY;
    private int scrollOffset = 0;
    private int scrollRenderY;

    private ChangelogScreen(ChangelogMap changelog, class_437 previousScreen) {
        super((class_2561)class_2561.method_43471((String)"screens.wynntils.changelog.name"));
        this.changelog = changelog;
        this.previousScreen = previousScreen;
    }

    public static class_437 create(ChangelogMap changelog, class_437 previousScreen) {
        return new ChangelogScreen(changelog, previousScreen);
    }

    public static class_437 create(ChangelogMap changelog) {
        return new ChangelogScreen(changelog, null);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.offsetX = (int)((float)(this.field_22789 - Texture.SCROLL_BACKGROUND.width()) / 2.0f);
        this.offsetY = (int)((float)(this.field_22790 - Texture.SCROLL_BACKGROUND.height()) / 2.0f);
        this.calculateRenderTasks();
        this.setCurrentPage(0);
        this.method_37063((class_364)new PageSelectorButton((int)(80.0f - (float)Texture.FORWARD_ARROW_OFFSET.width() / 2.0f + (float)this.offsetX), Texture.SCROLL_BACKGROUND.height() - 17 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), false, this));
        this.method_37063((class_364)new PageSelectorButton(Texture.SCROLL_BACKGROUND.width() - 80 + this.offsetX, Texture.SCROLL_BACKGROUND.height() - 17 + this.offsetY, Texture.FORWARD_ARROW_OFFSET.width() / 2, Texture.FORWARD_ARROW_OFFSET.height(), true, this));
        this.method_37063((class_364)new ExitFlagButton(this.offsetX - 35, this.offsetY + 24, this::method_25419));
    }

    public void method_25419() {
        super.method_25419();
        if (this.previousScreen != null) {
            McUtils.mc().method_1507(this.previousScreen);
        }
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        class_4587 poseStack = guiGraphics.method_51448();
        RenderUtils.drawTexturedRect(poseStack, Texture.SCROLL_BACKGROUND, this.offsetX, this.offsetY);
        RenderUtils.enableScissor(guiGraphics, this.offsetX + 40, this.offsetY + 11, 220, 165);
        FontRenderer.getInstance().renderTexts(poseStack, 45 + this.offsetX, 15 + this.offsetY - this.scrollOffset, this.changelogTasks.get(this.currentPage));
        RenderUtils.disableScissor(guiGraphics);
        if (this.getMaxScrollOffset() != 0) {
            this.renderScrollBar(poseStack);
        }
        this.renderPageInfo(poseStack, this.getCurrentPage() + 1, this.getMaxPage() + 1);
        for (class_4068 renderable : this.field_33816) {
            renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    private void renderPageInfo(class_4587 poseStack, int currentPage, int maxPage) {
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(currentPage + " / " + maxPage), (float)(80 + this.offsetX), (float)(Texture.SCROLL_BACKGROUND.width() - 80 + this.offsetX), (float)(Texture.SCROLL_BACKGROUND.height() - 17 + this.offsetY), 0.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, TextShadow.OUTLINE);
    }

    private void renderScrollBar(class_4587 poseStack) {
        RenderUtils.drawRect(poseStack, CommonColors.LIGHT_GRAY, this.offsetX + 268, this.offsetY + 14, 0.0f, 6.0f, 120.0f);
        this.scrollRenderY = (int)((float)(this.offsetY + 14) + MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, 100.0f));
        RenderUtils.drawRect(poseStack, this.draggingScroll ? CommonColors.BLACK : CommonColors.GRAY, this.offsetX + 268, this.scrollRenderY, 0.0f, 6.0f, 20.0f);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.draggingScroll && MathUtils.isInside((int)mouseX, (int)mouseY, this.offsetX + 268, this.offsetX + 268 + 6, this.scrollRenderY, this.scrollRenderY + 20)) {
            this.draggingScroll = true;
            return true;
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.draggingScroll) {
            int scrollAreaStartY = this.offsetY + 14 + 10;
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + 120 - 20, 0.0f, this.getMaxScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxScrollOffset()));
            this.scroll(newOffset);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingScroll = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        int scrollAmount = (int)(-deltaY * 10.0);
        int newOffset = Math.max(0, Math.min(this.scrollOffset + scrollAmount, this.getMaxScrollOffset()));
        this.scroll(newOffset);
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    private void scroll(int newOffset) {
        this.scrollOffset = newOffset;
    }

    private int getMaxScrollOffset() {
        float totalHeight = FontRenderer.getInstance().calculateRenderHeight(this.changelogTasks.get(this.currentPage));
        if (totalHeight <= 165.0f) {
            return 0;
        }
        return (int)(totalHeight - 165.0f);
    }

    private void calculateRenderTasks() {
        TextRenderSetting setting = TextRenderSetting.DEFAULT.withMaxWidth(Texture.SCROLL_BACKGROUND.width() - 85).withCustomColor(CommonColors.WHITE).withTextShadow(TextShadow.OUTLINE);
        this.changelogTasks = this.changelog.allChangelogs().stream().map(content -> Arrays.stream(content.split("\n")).map(StringUtils::convertMarkdownToColorCode).map(s -> new TextRenderTask((String)s, setting)).toList()).toList();
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public void setCurrentPage(int currentPage) {
        this.scrollOffset = 0;
        this.currentPage = MathUtils.clamp(currentPage, 0, this.getMaxPage());
    }

    @Override
    public int getMaxPage() {
        return Math.max(0, this.changelogTasks.size() - 1);
    }
}

