/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.container.widgets;

import com.google.common.collect.Lists;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.container.widgets.PersonalStorageUtilitiesWidget;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class QuickJumpButton
extends WynntilsButton {
    private final int destination;
    private final CustomColor lockedColor;
    private final CustomColor selectedColor;
    private final PersonalStorageUtilitiesWidget parent;

    public QuickJumpButton(int x, int y, int destination, CustomColor lockedColor, CustomColor selectedColor, PersonalStorageUtilitiesWidget parent) {
        super(x, y, 16, 16, (class_2561)class_2561.method_43470((String)"Container Quick Jump Button"));
        this.destination = destination;
        this.lockedColor = lockedColor;
        this.selectedColor = selectedColor;
        this.parent = parent;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        RenderUtils.drawHoverableTexturedRect(poseStack, Texture.QUICK_JUMP_BUTTON, this.method_46426(), this.method_46427(), this.field_22762);
        CustomColor color = CommonColors.WHITE;
        class_5250 tooltip = class_2561.method_43469((String)"feature.wynntils.personalStorageUtilities.jumpTo", (Object[])new Object[]{Models.Bank.getPageName(this.destination)});
        if (Models.Bank.getCurrentPage() == this.destination) {
            color = this.selectedColor;
            tooltip = class_2561.method_43471((String)"feature.wynntils.personalStorageUtilities.youAreHere");
        } else if (this.destination > Models.Bank.getFinalPage()) {
            color = this.lockedColor;
            tooltip = class_2561.method_43469((String)"feature.wynntils.personalStorageUtilities.unavailable", (Object[])new Object[]{this.destination});
        }
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(String.valueOf(this.destination)), this.method_46426() + 8, this.method_46427() + 8, color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        if (this.field_22762) {
            McUtils.mc().field_1755.method_47414(Lists.transform(List.of(tooltip), class_2561::method_30937));
        }
    }

    public void method_25306() {
        this.parent.jumpToPage(this.destination);
    }
}

