/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.gear;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.handlers.tooltip.impl.identifiable.IdentifiableTooltipBuilder;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.screens.guides.GuideItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class GuideGearItemStack
extends GuideItemStack {
    private final GearInfo gearInfo;
    private final class_5250 name;
    private List<class_2561> generatedTooltip;

    public GuideGearItemStack(GearInfo gearInfo) {
        super(gearInfo.metaInfo().material().itemStack(), new GearItem(gearInfo, null), gearInfo.name());
        this.gearInfo = gearInfo;
        this.name = class_2561.method_43470((String)gearInfo.name()).method_27692(gearInfo.tier().getChatFormatting());
        this.generatedTooltip = List.of();
    }

    public class_2561 method_7964() {
        return this.name;
    }

    public List<class_2561> method_7950(class_1792.class_9635 context, class_1657 player, class_1836 flag) {
        ArrayList<class_2561> tooltipLines = new ArrayList<class_2561>(this.generatedTooltip);
        this.appendObtainInfo(tooltipLines, Models.Gear.getObtainInfo(this.gearInfo));
        tooltipLines.add((class_2561)class_2561.method_43473());
        if (Services.Favorites.isFavorite(this)) {
            tooltipLines.add((class_2561)class_2561.method_43471((String)"screens.wynntils.wynntilsGuides.itemGuide.unfavorite").method_27692(class_124.field_1054));
        } else {
            tooltipLines.add((class_2561)class_2561.method_43471((String)"screens.wynntils.wynntilsGuides.itemGuide.favorite").method_27692(class_124.field_1060));
        }
        tooltipLines.add((class_2561)class_2561.method_43471((String)"screens.wynntils.wynntilsGuides.itemGuide.open").method_27692(class_124.field_1061));
        return tooltipLines;
    }

    public GearInfo getGearInfo() {
        return this.gearInfo;
    }

    public void buildTooltip() {
        IdentifiableTooltipBuilder tooltipBuilder = Handlers.Tooltip.buildNew(new GearItem(this.gearInfo, null), true, false);
        this.generatedTooltip = tooltipBuilder.getTooltipLines(Models.Character.getClassType());
        Optional<GearItem> gearItemOpt = Models.Item.asWynnItem(this, GearItem.class);
        if (gearItemOpt.isEmpty()) {
            return;
        }
        gearItemOpt.get().getData().clear("tooltip");
    }
}

