/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.guides.widgets.filters;

import com.google.common.collect.Lists;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.guides.WynntilsGuideScreen;
import com.wynntils.screens.guides.widgets.filters.GuideFilterWidget;
import com.wynntils.services.itemfilter.filters.BooleanStatFilter;
import com.wynntils.services.itemfilter.statproviders.FavoriteStatProvider;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.ConfirmedBoolean;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class FavoriteFilterWidget
extends GuideFilterWidget {
    private ConfirmedBoolean state;
    private FavoriteStatProvider provider;

    public FavoriteFilterWidget(int x, int y, WynntilsGuideScreen guideScreen, ItemSearchQuery searchQuery) {
        super(x, y, 16, 16, guideScreen);
        this.updateFromQuery(searchQuery);
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.drawRect(guiGraphics.method_51448(), CommonColors.BLACK.withAlpha(this.field_22762 ? 0.7f : 0.5f), this.method_46426(), this.method_46427(), 0.0f, this.method_25368(), this.method_25364());
        FontRenderer.getInstance().renderText(guiGraphics.method_51448(), StyledText.fromString(this.state == ConfirmedBoolean.UNCONFIRMED ? "\u2606" : "\u2605"), (float)this.method_46426() + (float)this.method_25368() / 2.0f, (float)this.method_46427() + (float)this.method_25364() / 2.0f + 1.0f, this.getStarColor(), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NONE);
        if (this.field_22762) {
            McUtils.mc().field_1755.method_47414(Lists.transform(ComponentUtils.wrapTooltips(List.of(class_2561.method_43469((String)"screens.wynntils.wynntilsGuides.filterWidget.tooltip", (Object[])new Object[]{class_1074.method_4662((String)"service.wynntils.itemFilter.stat.favorite.name", (Object[])new Object[0])})), 200), class_2561::method_30937));
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            if (this.state != ConfirmedBoolean.TRUE) {
                this.state = ConfirmedBoolean.TRUE;
            } else if (this.state != ConfirmedBoolean.FALSE) {
                this.state = ConfirmedBoolean.FALSE;
            }
        } else if (button == 2) {
            this.state = ConfirmedBoolean.UNCONFIRMED;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    protected List<StatProviderAndFilterPair> getFilters() {
        if (this.state == ConfirmedBoolean.UNCONFIRMED) {
            return List.of();
        }
        return List.of(new StatProviderAndFilterPair<Boolean>(this.provider, new BooleanStatFilter.BooleanStatFilterFactory().fromBoolean(this.state == ConfirmedBoolean.TRUE)));
    }

    @Override
    public void getProvider() {
        this.provider = Services.ItemFilter.getItemStatProviders().stream().filter(statProvider -> statProvider instanceof FavoriteStatProvider).map(statProvider -> (FavoriteStatProvider)statProvider).findFirst().orElseThrow(() -> new IllegalStateException("Could not get favorite stat provider"));
    }

    @Override
    public void updateFromQuery(ItemSearchQuery searchQuery) {
        Optional<StatProviderAndFilterPair> filterPairOpt = searchQuery.filters().values().stream().filter(filterPair -> filterPair.statProvider() instanceof FavoriteStatProvider).findFirst();
        if (filterPairOpt.isPresent()) {
            if (filterPairOpt.get().statFilter().matches(true)) {
                this.state = ConfirmedBoolean.TRUE;
            } else if (filterPairOpt.get().statFilter().matches(false)) {
                this.state = ConfirmedBoolean.FALSE;
            }
        } else {
            this.state = ConfirmedBoolean.UNCONFIRMED;
        }
    }

    private CustomColor getStarColor() {
        return switch (this.state) {
            default -> throw new MatchException(null, null);
            case ConfirmedBoolean.UNCONFIRMED -> CommonColors.WHITE;
            case ConfirmedBoolean.TRUE -> CommonColors.YELLOW;
            case ConfirmedBoolean.FALSE -> CommonColors.RED;
        };
    }
}

