/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter;

import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.screens.WynntilsScreen;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.ItemSearchWidget;
import com.wynntils.screens.base.widgets.SearchWidget;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.itemfilter.widgets.FilterOptionsButton;
import com.wynntils.screens.itemfilter.widgets.PresetButton;
import com.wynntils.screens.itemfilter.widgets.ProviderButton;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.screens.itemfilter.widgets.SortWidget;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.SortInfo;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_7919;

public final class ItemFilterScreen
extends WynntilsScreen {
    private static final float SCROLL_FACTOR = 10.0f;
    private static final int MAX_PRESETS = 4;
    private static final int MAX_PROVIDERS_PER_PAGE = 8;
    private static final int MAX_SORTS_PER_PAGE = 7;
    private static final int PROVIDER_MASK_TOP_Y = 25;
    private static final int PROVIDER_MASK_BOTTOM_Y = 197;
    private final List<ItemProviderType> supportedProviderTypes;
    private List<ItemStatProvider<?>> itemStatProviders = new ArrayList();
    private List<SortInfo> sorts = new ArrayList<SortInfo>();
    private List<Pair<String, String>> presets;
    private List<SortWidget> sortButtons = new ArrayList<SortWidget>();
    private List<WynntilsButton> presetButtons = new ArrayList<WynntilsButton>();
    private List<WynntilsButton> providerButtons = new ArrayList<WynntilsButton>();
    private Map<ItemStatProvider<?>, List<StatProviderAndFilterPair>> filterMap = new HashMap();
    private final SearchWidget itemSearchWidget;
    private final SearchWidget previousSearchWidget;
    private final SearchWidget providerSearchWidget;
    private final TextInputBoxWidget itemNameInput;
    private class_4185 applyButton;
    private class_4185 savePresetButton;
    private class_4185 toggleSortButton;
    private FilterOptionsButton allButton;
    private FilterOptionsButton usedButton;
    private FilterOptionsButton unusedButton;
    private FilterOptionsButton selectedFilterButton;
    private ProviderFilterListWidget filterWidget;
    private TextInputBoxWidget focusedTextInput;
    private TextInputBoxWidget presetNameInput;
    private WynntilsButton nextPresetButton;
    private WynntilsButton previousPresetButton;
    private boolean draggingProviderScroll = false;
    private boolean draggingSortScroll = false;
    private float providerScrollY;
    private float sortScrollY;
    private int presetsScrollOffset = 0;
    private int providersScrollOffset = 0;
    private int sortScrollOffset = 0;
    private int offsetX;
    private int offsetY;
    private class_4068 hovered = null;
    private final boolean supportsSorting;
    private final class_437 previousScreen;
    private boolean sortMode = false;
    private FilterType filterType = FilterType.ALL;
    private ItemStatProvider<?> selectedProvider;

    private ItemFilterScreen(SearchWidget searchWidget, class_437 previousScreen, boolean supportsSorting, List<ItemProviderType> supportedProviderTypes) {
        super((class_2561)class_2561.method_43470((String)"Item Filter Screen"));
        this.previousSearchWidget = searchWidget;
        this.previousScreen = previousScreen;
        this.supportsSorting = supportsSorting;
        this.supportedProviderTypes = supportedProviderTypes;
        this.itemNameInput = new TextInputBoxWidget(220, 5, 100, 18, s -> this.updateQueryString(), this);
        this.providerSearchWidget = new SearchWidget(7, 5, supportsSorting ? 100 : 120, 20, s -> {
            this.providersScrollOffset = 0;
            this.updateProviderWidgets();
        }, this);
        this.itemSearchWidget = new ItemSearchWidget(0, -22, Texture.ITEM_FILTER_BACKGROUND.width() - 40, 20, supportedProviderTypes, supportsSorting, query -> {
            if (this.applyButton == null) {
                return;
            }
            this.applyButton.field_22763 = true;
        }, this);
        this.itemSearchWidget.setTextBoxInput(this.previousSearchWidget.getTextBoxInput());
        this.setFocusedTextInput(this.providerSearchWidget);
        this.presets = (List)Services.ItemFilter.presets.get();
    }

    public static class_437 create(SearchWidget searchWidget, class_437 previousScreen, boolean supportsSorting, List<ItemProviderType> supportedProviderTypes) {
        return new ItemFilterScreen(searchWidget, previousScreen, supportsSorting, supportedProviderTypes);
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.offsetX = (int)((float)(this.field_22789 - Texture.ITEM_FILTER_BACKGROUND.width()) / 2.0f);
        this.offsetY = (int)((float)(this.field_22790 - Texture.ITEM_FILTER_BACKGROUND.height()) / 2.0f);
        this.itemNameInput.method_46421(220 + this.offsetX);
        this.itemNameInput.method_46419(5 + this.offsetY);
        this.providerSearchWidget.method_46421(7 + this.offsetX);
        this.providerSearchWidget.method_46419(5 + this.offsetY);
        this.itemSearchWidget.method_46421(this.offsetX);
        this.itemSearchWidget.method_46419(-22 + this.offsetY);
        this.method_37063((class_364)this.itemSearchWidget);
        this.method_37063((class_364)this.providerSearchWidget);
        this.method_37063((class_364)this.itemNameInput);
        this.presetNameInput = new TextInputBoxWidget(220 + this.offsetX, 180 + this.offsetY, 100, 20, s -> this.checkSaveStatus(), this, this.presetNameInput);
        this.method_37063((class_364)this.presetNameInput);
        if (this.supportsSorting) {
            this.toggleSortButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)(this.sortMode ? "\ud83d\udd0d" : "\u21c5")), button -> this.toggleSortMode()).method_46433(108 + this.offsetX, 5 + this.offsetY).method_46437(20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)(this.sortMode ? "screens.wynntils.itemFilter.filterToggle" : "screens.wynntils.itemFilter.sortToggle")))).method_46431();
            this.method_37063((class_364)this.toggleSortButton);
        }
        class_4185 returnButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\u23ce"), button -> this.method_25419()).method_46433(Texture.ITEM_FILTER_BACKGROUND.width() - 18 + this.offsetX, -22 + this.offsetY).method_46437(20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.return"))).method_46431();
        this.method_37063((class_364)returnButton);
        boolean activeApply = this.applyButton != null && this.applyButton.field_22763;
        this.applyButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\u2714").method_27692(class_124.field_1060), button -> {
            this.providersScrollOffset = 0;
            this.sortScrollOffset = 0;
            this.updateStateFromItemSearchWidget();
            this.applyButton.field_22763 = false;
        }).method_46433(Texture.ITEM_FILTER_BACKGROUND.width() - 39 + this.offsetX, -22 + this.offsetY).method_46437(20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.apply"))).method_46431();
        this.applyButton.field_22763 = activeApply;
        this.method_37063((class_364)this.applyButton);
        this.savePresetButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\ud83d\udcbe"), button -> this.savePreset()).method_46433(330 + this.offsetX, 180 + this.offsetY).method_46437(20, 20).method_46431();
        this.savePresetButton.field_22763 = !this.presetNameInput.getTextBoxInput().isEmpty() && !this.itemSearchWidget.getTextBoxInput().isEmpty();
        this.method_37063((class_364)this.savePresetButton);
        this.previousPresetButton = (WynntilsButton)this.method_37063((class_364)new PresetButton(Texture.ITEM_FILTER_BACKGROUND.width() - 4 + this.offsetX, 4 + this.offsetY, StyledText.fromString("\ud83e\udc1d"), b -> this.scrollPresets(-1), List.of(class_2561.method_43471((String)"screens.wynntils.itemFilter.scrollUp")), this.offsetX, this.offsetY));
        this.nextPresetButton = (WynntilsButton)this.method_37063((class_364)new PresetButton(Texture.ITEM_FILTER_BACKGROUND.width() - 4 + this.offsetX, 174 + this.offsetY, StyledText.fromString("\ud83e\udc1f"), b -> this.scrollPresets(1), List.of(class_2561.method_43471((String)"screens.wynntils.itemFilter.scrollDown")), this.offsetX, this.offsetY));
        if (this.presets.size() <= 4) {
            this.previousPresetButton.field_22764 = false;
            this.nextPresetButton.field_22764 = false;
        }
        this.allButton = new FilterOptionsButton(-Texture.BUTTON_LEFT.width() + 4 + this.offsetX, 8 + this.offsetY, Texture.BUTTON_LEFT.width(), Texture.BUTTON_LEFT.height() / 2, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.allFilter")), button -> this.setSelectedFilter(FilterType.ALL), List.of(class_2561.method_43471((String)"screens.wynntils.itemFilter.allFilterTooltip")), Texture.BUTTON_LEFT, this.filterType == FilterType.ALL, this.offsetX, this.offsetY);
        this.usedButton = new FilterOptionsButton(-Texture.BUTTON_LEFT.width() + 4 + this.offsetX, 12 + Texture.BUTTON_LEFT.height() / 2 + this.offsetY, Texture.BUTTON_LEFT.width(), Texture.BUTTON_LEFT.height() / 2, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.usedFilter")), button -> this.setSelectedFilter(FilterType.USED), List.of(class_2561.method_43471((String)"screens.wynntils.itemFilter.usedFilterTooltip")), Texture.BUTTON_LEFT, this.filterType == FilterType.USED, this.offsetX, this.offsetY);
        this.unusedButton = new FilterOptionsButton(-Texture.BUTTON_LEFT.width() + 4 + this.offsetX, 16 + Texture.BUTTON_LEFT.height() / 2 * 2 + this.offsetY, Texture.BUTTON_LEFT.width(), Texture.BUTTON_LEFT.height() / 2, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.unusedFilter")), button -> this.setSelectedFilter(FilterType.UNUSED), List.of(class_2561.method_43471((String)"screens.wynntils.itemFilter.unusedFilterTooltip")), Texture.BUTTON_LEFT, this.filterType == FilterType.UNUSED, this.offsetX, this.offsetY);
        switch (this.filterType.ordinal()) {
            case 1: {
                this.selectedFilterButton = this.usedButton;
                break;
            }
            case 2: {
                this.selectedFilterButton = this.unusedButton;
                break;
            }
            default: {
                this.selectedFilterButton = this.allButton;
            }
        }
        this.method_37063((class_364)this.allButton);
        this.method_37063((class_364)this.usedButton);
        this.method_37063((class_364)this.unusedButton);
        this.filterWidget = null;
        this.updateProviderWidgets();
        this.updatePresetWidgets();
        this.updateStateFromItemSearchWidget();
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        WynntilsButton wynntilsButton;
        class_4587 poseStack = guiGraphics.method_51448();
        this.hovered = null;
        RenderUtils.drawTexturedRect(poseStack, Texture.ITEM_FILTER_BACKGROUND, this.offsetX, this.offsetY);
        if (this.selectedProvider == null && !this.sortMode) {
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.unselectedFilter")), 147 + this.offsetX, 345 + this.offsetX, 63 + this.offsetY, 123 + this.offsetY, 200.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        } else if (this.sortMode && this.sorts.isEmpty()) {
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.noSorts")), 147 + this.offsetX, 345 + this.offsetX, 63 + this.offsetY, 123 + this.offsetY, 200.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        }
        if (!this.sortMode) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.itemName")), 150 + this.offsetX, 10 + this.offsetY, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL);
        }
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.presetName")), 150 + this.offsetX, 185 + this.offsetY, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL);
        for (class_4068 class_40682 : this.field_33816) {
            class_40682.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            if (!(class_40682 instanceof WynntilsButton) || !(wynntilsButton = (WynntilsButton)class_40682).method_25405(mouseX, mouseY)) continue;
            this.hovered = class_40682;
        }
        if (this.providerButtons.isEmpty()) {
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromComponent((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.noProviders")), 8 + this.offsetX, 127 + this.offsetX, 28 + this.offsetY, 169 + this.offsetY, 118.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        } else {
            RenderUtils.enableScissor(guiGraphics, 6 + this.offsetX, 28 + this.offsetY, 122, 170);
            for (class_4068 class_40683 : this.providerButtons) {
                class_40683.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
            RenderUtils.disableScissor(guiGraphics);
        }
        RenderUtils.enableScissor(guiGraphics, 149 + this.offsetX, 28 + this.offsetY, 172, 149);
        for (class_4068 class_40684 : this.sortButtons) {
            class_40684.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        RenderUtils.disableScissor(guiGraphics);
        for (class_4068 class_40685 : this.presetButtons) {
            class_40685.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            if (!(class_40685 instanceof WynntilsButton) || !(wynntilsButton = (WynntilsButton)class_40685).method_25405(mouseX, mouseY)) continue;
            this.hovered = class_40685;
        }
        if (this.itemStatProviders.size() > 8) {
            this.renderProvidersScroll(poseStack);
        }
        if (this.sortMode && this.sorts.size() > 7) {
            this.renderSortScroll(poseStack);
        }
        this.renderTooltips(guiGraphics, mouseX, mouseY);
    }

    public void method_49589() {
        this.providerSearchWidget.opened();
        super.method_49589();
    }

    public void method_25419() {
        this.previousSearchWidget.setTextBoxInput(this.itemSearchWidget.getTextBoxInput());
        McUtils.mc().method_1507(this.previousScreen);
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (!this.draggingProviderScroll && this.itemStatProviders.size() > 8 && MathUtils.isInside((int)mouseX, (int)mouseY, 133 + this.offsetX, 133 + Texture.SCROLL_BUTTON.width() + this.offsetX, (int)this.providerScrollY, (int)(this.providerScrollY + (float)Texture.SCROLL_BUTTON.height()))) {
            this.draggingProviderScroll = true;
            return true;
        }
        if (this.sortMode && !this.draggingSortScroll && this.sorts.size() > 7 && MathUtils.isInside((int)mouseX, (int)mouseY, 330, 336, (int)this.sortScrollY, (int)(this.sortScrollY + 20.0f))) {
            this.draggingSortScroll = true;
            return true;
        }
        for (class_364 listener : this.getWidgetsForIteration().toList()) {
            if (!listener.method_25405(mouseX, mouseY)) continue;
            if ((listener instanceof PresetButton || listener instanceof FilterOptionsButton) && MathUtils.isInside((int)mouseX, (int)mouseY, this.offsetX, Texture.ITEM_FILTER_BACKGROUND.width() + this.offsetX, this.offsetY, Texture.ITEM_FILTER_BACKGROUND.height() + this.offsetY)) {
                return false;
            }
            listener.method_25402(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.filterWidget != null && !this.filterWidget.method_25405(mouseX, mouseY)) {
            this.filterWidget.method_25406(mouseX, mouseY, button);
        }
        if (this.draggingProviderScroll) {
            int scrollAreaStartY = 34 + this.offsetY;
            int scrollAreaHeight = 168 - Texture.SCROLL_BUTTON.height();
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + scrollAreaHeight, 0.0f, this.getMaxProviderScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxProviderScrollOffset()));
            this.scrollProviders(newOffset);
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        if (this.draggingSortScroll) {
            int scrollAreaStartY = 40;
            int scrollAreaHeight = 127;
            int newOffset = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + scrollAreaHeight, 0.0f, this.getMaxSortsScrollOffset()));
            newOffset = Math.max(0, Math.min(newOffset, this.getMaxSortsScrollOffset()));
            this.scrollSorts(newOffset);
            return true;
        }
        for (class_364 listener : this.field_22786) {
            if (!listener.method_25405(mouseX, mouseY)) continue;
            return listener.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.draggingProviderScroll = false;
        this.draggingSortScroll = false;
        for (class_364 listener : this.field_22786) {
            if (!listener.method_25405(mouseX, mouseY)) continue;
            return listener.method_25406(mouseX, mouseY, button);
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        double scrollValue = -Math.signum(deltaY);
        for (class_364 listener : this.field_22786) {
            if (!listener.method_25405(mouseX, mouseY) || !listener.method_25401(mouseX, mouseY, deltaX, deltaY)) continue;
            return true;
        }
        if (this.presets.size() > 4 && mouseX >= (double)(Texture.ITEM_FILTER_BACKGROUND.width() + this.offsetX)) {
            this.scrollPresets((int)scrollValue);
            return true;
        }
        int scrollAmount = (int)(-deltaY * 10.0);
        if (this.sortMode && mouseX >= (double)(150 + this.offsetX)) {
            int newOffset = Math.max(0, Math.min(this.sortScrollOffset + scrollAmount, this.getMaxSortsScrollOffset()));
            this.scrollSorts(newOffset);
        } else {
            int newOffset = Math.max(0, Math.min(this.providersScrollOffset + scrollAmount, this.getMaxProviderScrollOffset()));
            this.scrollProviders(newOffset);
        }
        return true;
    }

    @Override
    public boolean method_25400(char codePoint, int modifiers) {
        return this.focusedTextInput != null && this.focusedTextInput.method_25400(codePoint, modifiers);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.method_25422()) {
            this.method_25419();
            return true;
        }
        if (keyCode == 257 && this.applyButton.field_22763) {
            this.updateStateFromItemSearchWidget();
            this.applyButton.field_22763 = false;
        }
        return this.focusedTextInput != null && this.focusedTextInput.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public TextInputBoxWidget getFocusedTextInput() {
        return this.focusedTextInput;
    }

    @Override
    public void setFocusedTextInput(TextInputBoxWidget focusedTextInput) {
        this.focusedTextInput = focusedTextInput;
    }

    public void setFiltersForProvider(ItemStatProvider<?> provider, List<StatProviderAndFilterPair> filterPairs) {
        this.filterMap.remove(provider);
        if (filterPairs != null && !filterPairs.isEmpty()) {
            this.filterMap.put(provider, filterPairs);
        }
        this.updateQueryString();
    }

    public void updateFilterWidget() {
        if (this.filterWidget != null && this.selectedProvider != null) {
            this.filterWidget.onFiltersChanged(this.filterMap.getOrDefault(this.selectedProvider, List.of()));
        }
    }

    public void addSort(SortInfo newSort) {
        this.sorts = this.sorts.stream().filter(sort -> sort.provider() != newSort.provider()).collect(Collectors.toList());
        this.sorts.add(newSort);
        this.updateQueryString();
        this.updateSortWidgets();
    }

    public void removeSort(ItemStatProvider<?> provider) {
        this.sorts.removeIf(sort -> sort.provider() == provider);
        this.updateQueryString();
        this.updateSortWidgets();
    }

    public void changeSort(SortInfo oldSortInfo, SortInfo newSortInfo) {
        this.sorts = this.sorts.stream().map(sort -> {
            if (sort.equals(oldSortInfo)) {
                return newSortInfo;
            }
            return sort;
        }).collect(Collectors.toList());
        this.updateQueryString();
        this.updateSortWidgets();
    }

    public void reorderSort(SortInfo sortInfo, int direction) {
        int indexOf = this.sorts.indexOf(sortInfo);
        if (indexOf == -1) {
            return;
        }
        SortInfo sort = this.sorts.get(indexOf);
        this.sorts.remove(sort);
        this.sorts.add(indexOf + direction, sort);
        this.updateQueryString();
        this.updateSortWidgets();
    }

    public boolean inSortMode() {
        return this.sortMode;
    }

    public Pair<Boolean, Boolean> canSortMove(SortInfo sortInfo) {
        int index = this.sorts.indexOf(sortInfo);
        return Pair.of(index != 0, index != this.sorts.size() - 1);
    }

    public void setSelectedProvider(ItemStatProvider<?> selectedProvider) {
        this.selectedProvider = selectedProvider;
        this.createValueWidget();
    }

    public ItemStatProvider<?> getSelectedProvider() {
        return this.selectedProvider;
    }

    public boolean isProviderInUse(ItemStatProvider<?> provider) {
        return this.filterMap.containsKey(provider) || this.sorts.stream().anyMatch(sort -> sort.provider() == provider);
    }

    public int getProviderMaskTopY() {
        return 25 + this.offsetY;
    }

    public int getProviderMaskBottomY() {
        return 197 + this.offsetY;
    }

    private void updateProviderWidgets() {
        for (class_339 class_3392 : this.providerButtons) {
            this.method_37066((class_364)class_3392);
        }
        this.providerButtons = new ArrayList<WynntilsButton>();
        this.itemStatProviders = Services.ItemFilter.getItemStatProviders().stream().filter(itemStatProvider -> itemStatProvider.getFilterTypes().stream().anyMatch(this.supportedProviderTypes::contains)).filter(provider -> this.searchMatches(provider.getDisplayName())).toList();
        if (this.filterType == FilterType.USED) {
            this.itemStatProviders = this.itemStatProviders.stream().filter(this::isProviderInUse).toList();
        } else if (this.filterType == FilterType.UNUSED) {
            this.itemStatProviders = this.itemStatProviders.stream().filter(provider -> !this.isProviderInUse((ItemStatProvider<?>)provider)).toList();
        }
        int yPos = 31 + this.offsetY;
        for (ItemStatProvider<?> itemStatProvider2 : this.itemStatProviders) {
            this.providerButtons.add(new ProviderButton(7 + this.offsetX, yPos, 120, 18, this, itemStatProvider2));
            yPos += 21;
        }
        if (this.selectedProvider != null) {
            Stream stream = Services.ItemFilter.getItemStatProviders().stream();
            ItemStatProvider itemStatProvider3 = stream.filter(provider -> provider.getName().equals(this.selectedProvider.getName())).findFirst().orElse(null);
            this.setSelectedProvider(itemStatProvider3);
        }
        this.scrollProviders(this.providersScrollOffset);
    }

    private void updateStateFromItemSearchWidget() {
        this.parseFilters();
        this.updateProviderWidgets();
        if (this.sortMode) {
            this.updateSortWidgets();
        }
        this.updateFilterWidget();
    }

    /*
     * WARNING - void declaration
     */
    private void updatePresetWidgets() {
        void var2_5;
        for (class_339 class_3392 : this.presetButtons) {
            this.method_37066((class_364)class_3392);
        }
        this.presetButtons = new ArrayList<WynntilsButton>();
        if (this.presets.isEmpty()) {
            return;
        }
        int yPos = 4 + this.offsetY;
        boolean bl = false;
        while (var2_5 < Math.min(4, this.presets.size())) {
            yPos += Texture.BUTTON_RIGHT.height() / 2 + 6;
            void presetIndex = var2_5 + this.presetsScrollOffset < 0 ? var2_5 + this.presetsScrollOffset + this.presets.size() : (var2_5 + this.presetsScrollOffset > this.presets.size() - 1 ? var2_5 + this.presetsScrollOffset - this.presets.size() : var2_5 + this.presetsScrollOffset);
            if (presetIndex > this.presets.size() - 1) break;
            String presetName = this.presets.get((int)presetIndex).a();
            List<class_2561> tooltip = new ArrayList<class_2561>();
            tooltip.add((class_2561)class_2561.method_43470((String)presetName));
            tooltip.add((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.presetHelp1"));
            tooltip.add((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.presetHelp2"));
            tooltip.add((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.presetHelp3"));
            tooltip.add((class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.presetHelp4"));
            tooltip = ComponentUtils.wrapTooltips(tooltip, 200);
            this.presetButtons.add(new PresetButton(Texture.ITEM_FILTER_BACKGROUND.width() - 4 + this.offsetX, yPos, StyledText.fromString(presetName), arg_0 -> this.lambda$updatePresetWidgets$21((int)presetIndex, arg_0), tooltip, this.offsetX, this.offsetY));
            ++var2_5;
        }
    }

    private void updateSortWidgets() {
        for (class_339 class_3392 : this.sortButtons) {
            this.method_37066((class_364)class_3392);
        }
        this.sortButtons = new ArrayList<SortWidget>();
        int yPos = 29 + this.offsetY;
        for (SortInfo sort : this.sorts) {
            this.sortButtons.add(new SortWidget(150 + this.offsetX, yPos, this, sort));
            yPos += 21;
        }
        this.scrollSorts(this.sortScrollOffset);
    }

    private void createValueWidget() {
        if (this.filterWidget != null) {
            this.method_37066((class_364)this.filterWidget);
        }
        this.filterWidget = new ProviderFilterListWidget(150 + this.offsetX, 30 + this.offsetY, this, this.selectedProvider, this.filterMap.getOrDefault(this.selectedProvider, List.of()));
        this.method_37063((class_364)this.filterWidget);
    }

    private void scrollProviders(int newOffset) {
        this.providersScrollOffset = newOffset;
        for (WynntilsButton provider : this.providerButtons) {
            int newY = 31 + this.offsetY + this.providerButtons.indexOf((Object)provider) * 21 - this.providersScrollOffset;
            provider.method_46419(newY);
            provider.field_22764 = newY >= 31 + this.offsetY - 21 && newY <= 31 + this.offsetY + 189;
        }
    }

    private void scrollSorts(int newOffset) {
        this.sortScrollOffset = newOffset;
        for (SortWidget sort : this.sortButtons) {
            int newY = 31 + this.offsetY + this.sortButtons.indexOf((Object)sort) * 21 - this.sortScrollOffset;
            sort.method_46419(newY);
            sort.field_22764 = newY >= 31 + this.offsetY - 21 && newY <= 31 + this.offsetY + 168;
        }
    }

    private void scrollPresets(int direction) {
        this.presetsScrollOffset = Math.abs(this.presetsScrollOffset + direction) == this.presets.size() ? 0 : MathUtils.clamp(this.presetsScrollOffset + direction, -(this.presets.size() - 1), this.presets.size() - 1);
        this.updatePresetWidgets();
    }

    private int getMaxProviderScrollOffset() {
        return (this.itemStatProviders.size() - 8) * 21;
    }

    private int getMaxSortsScrollOffset() {
        return (this.sorts.size() - 7) * 21;
    }

    private void clickPreset(int button, int presetIndex) {
        if (button == 0) {
            if (KeyboardUtils.isShiftDown()) {
                int indexToSwap = presetIndex == 0 ? this.presets.size() - 1 : presetIndex - 1;
                Collections.swap(this.presets, presetIndex, indexToSwap);
                Services.ItemFilter.presets.store(this.presets);
                Services.ItemFilter.presets.touched();
                this.presets = (List)Services.ItemFilter.presets.get();
                this.updatePresetWidgets();
            } else {
                this.itemSearchWidget.setTextBoxInput(this.presets.get(presetIndex).b());
                this.updateStateFromItemSearchWidget();
            }
        } else if (button == 1) {
            if (KeyboardUtils.isShiftDown()) {
                int indexToSwap = presetIndex == this.presets.size() - 1 ? 0 : presetIndex + 1;
                Collections.swap(this.presets, presetIndex, indexToSwap);
                Services.ItemFilter.presets.store(this.presets);
                Services.ItemFilter.presets.touched();
                this.presets = (List)Services.ItemFilter.presets.get();
                this.updatePresetWidgets();
            } else if (KeyboardUtils.isControlDown()) {
                this.presets.remove(presetIndex);
                Services.ItemFilter.presets.store(this.presets);
                Services.ItemFilter.presets.touched();
                this.presets = (List)Services.ItemFilter.presets.get();
                this.presetsScrollOffset = Math.max(this.presetsScrollOffset - 1, 0);
                this.updatePresetWidgets();
                if (this.presets.size() <= 4) {
                    this.nextPresetButton.field_22764 = false;
                    this.previousPresetButton.field_22764 = false;
                }
            }
        }
    }

    private void savePreset() {
        this.presets.add(new Pair<String, String>(this.presetNameInput.getTextBoxInput(), this.itemSearchWidget.getTextBoxInput()));
        Services.ItemFilter.presets.store(this.presets);
        Services.ItemFilter.presets.touched();
        this.presetNameInput.setTextBoxInput("");
        if (this.presets.size() > 4) {
            this.nextPresetButton.field_22764 = true;
            this.previousPresetButton.field_22764 = true;
        }
        this.updatePresetWidgets();
    }

    private void checkSaveStatus() {
        if (this.presetNameInput == null || this.itemSearchWidget == null) {
            return;
        }
        this.savePresetButton.field_22763 = !this.presetNameInput.getTextBoxInput().isEmpty() && !this.itemSearchWidget.getTextBoxInput().isEmpty();
    }

    private void toggleSortMode() {
        this.sortMode = !this.sortMode;
        boolean bl = this.itemNameInput.field_22764 = !this.sortMode;
        if (this.sortMode) {
            if (this.filterWidget != null) {
                this.selectedProvider = null;
                this.method_37066((class_364)this.filterWidget);
            }
            this.sortScrollOffset = 0;
            this.updateSortWidgets();
        } else {
            for (class_339 class_3392 : this.sortButtons) {
                this.method_37066((class_364)class_3392);
            }
            this.sortButtons = new ArrayList<SortWidget>();
        }
        this.toggleSortButton.method_25355((class_2561)class_2561.method_43470((String)(this.sortMode ? "\ud83d\udd0d" : "\u21c5")));
        this.toggleSortButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)(this.sortMode ? "screens.wynntils.itemFilter.filterToggle" : "screens.wynntils.itemFilter.sortToggle"))));
    }

    private void parseFilters() {
        ItemSearchQuery searchQuery = Services.ItemFilter.createSearchQuery(this.itemSearchWidget.getTextBoxInput(), true, this.supportedProviderTypes);
        this.filterMap = new HashMap(searchQuery.filters().entries());
        this.sorts = searchQuery.sorts();
        String plainTextString = String.join((CharSequence)" ", searchQuery.plainTextTokens());
        if (plainTextString.equals(this.itemNameInput.getTextBoxInput())) {
            return;
        }
        this.itemNameInput.setTextBoxInput(plainTextString);
    }

    private void updateQueryString() {
        String queryString = Services.ItemFilter.getItemFilterString(this.filterMap, this.sorts, List.of(this.itemNameInput.getTextBoxInput()));
        if (Objects.equals(this.itemSearchWidget.getTextBoxInput(), queryString)) {
            return;
        }
        this.itemSearchWidget.setTextBoxInput(queryString);
        if (this.applyButton != null) {
            this.applyButton.field_22763 = false;
        }
        this.savePresetButton.field_22763 = !this.presetNameInput.getTextBoxInput().isEmpty() && !this.itemSearchWidget.getTextBoxInput().isEmpty();
    }

    private void renderTooltips(class_332 guiGraphics, int mouseX, int mouseY) {
        if ((this.hovered instanceof PresetButton || this.hovered instanceof FilterOptionsButton) && MathUtils.isInside(mouseX, mouseY, this.offsetX, Texture.ITEM_FILTER_BACKGROUND.width() + this.offsetX, this.offsetY, Texture.ITEM_FILTER_BACKGROUND.height() + this.offsetY)) {
            return;
        }
        List<Object> tooltipLines = List.of();
        class_4068 class_40682 = this.hovered;
        if (class_40682 instanceof TooltipProvider) {
            TooltipProvider tooltipWidget = (TooltipProvider)class_40682;
            tooltipLines = tooltipWidget.getTooltipLines();
        }
        if (tooltipLines.isEmpty()) {
            return;
        }
        guiGraphics.method_51434(FontRenderer.getInstance().getFont(), tooltipLines, mouseX, mouseY);
    }

    private void renderProvidersScroll(class_4587 poseStack) {
        this.providerScrollY = (float)(24 + this.offsetY) + MathUtils.map(this.providersScrollOffset, 0.0f, this.getMaxProviderScrollOffset(), 0.0f, 177 - Texture.CONFIG_BOOK_SCROLL_BUTTON.height());
        RenderUtils.drawTexturedRect(poseStack, Texture.SCROLL_BUTTON, 133 + this.offsetX, this.providerScrollY);
    }

    private void renderSortScroll(class_4587 poseStack) {
        RenderUtils.drawRect(poseStack, CommonColors.LIGHT_GRAY, 330 + this.offsetX, 30 + this.offsetY, 0.0f, 6.0f, 147.0f);
        this.sortScrollY = (float)(30 + this.offsetY) + MathUtils.map(this.sortScrollOffset, 0.0f, this.getMaxSortsScrollOffset(), 0.0f, 127.0f);
        RenderUtils.drawRect(poseStack, this.draggingSortScroll ? CommonColors.BLACK : CommonColors.GRAY, 330 + this.offsetX, this.sortScrollY, 0.0f, 6.0f, 20.0f);
    }

    private void setSelectedFilter(FilterType newFilter) {
        this.selectedFilterButton.setIsSelected(false);
        switch (newFilter.ordinal()) {
            case 1: {
                this.usedButton.setIsSelected(true);
                this.selectedFilterButton = this.usedButton;
                break;
            }
            case 2: {
                this.unusedButton.setIsSelected(true);
                this.selectedFilterButton = this.unusedButton;
                break;
            }
            default: {
                this.allButton.setIsSelected(true);
                this.selectedFilterButton = this.allButton;
            }
        }
        this.filterType = newFilter;
        this.providersScrollOffset = 0;
        this.updateProviderWidgets();
    }

    private boolean searchMatches(String name) {
        return StringUtils.partialMatch(name, this.providerSearchWidget.getTextBoxInput());
    }

    private Stream<class_364> getWidgetsForIteration() {
        return Stream.concat(this.field_22786.stream(), Stream.concat(this.providerButtons.stream(), Stream.concat(this.sortButtons.stream(), this.presetButtons.stream())));
    }

    private static enum FilterType {
        ALL,
        USED,
        UNUSED;

    }
}

