/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets;

import com.wynntils.screens.base.widgets.WynntilsCheckbox;
import com.wynntils.screens.itemfilter.widgets.GeneralFilterWidget;
import com.wynntils.screens.itemfilter.widgets.ProviderFilterListWidget;
import com.wynntils.services.itemfilter.filters.BooleanStatFilter;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.type.ConfirmedBoolean;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class BooleanFilterWidget
extends GeneralFilterWidget {
    private final WynntilsCheckbox trueCheckbox;
    private final WynntilsCheckbox falseCheckbox;
    private ConfirmedBoolean state = ConfirmedBoolean.UNCONFIRMED;

    protected BooleanFilterWidget(int x, int y, StatProviderAndFilterPair filterPair, ProviderFilterListWidget parent) {
        super(x, y, 195, 145, (class_2561)class_2561.method_43470((String)"Boolean Filter Widget"), parent);
        this.trueCheckbox = new WynntilsCheckbox(this.method_46426() + 10, this.method_46427() + 35, 20, (class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.booleanTrue"), this.state == ConfirmedBoolean.TRUE, 150, (checkbox, b) -> {
            if (b.booleanValue()) {
                this.toggleState(ConfirmedBoolean.TRUE);
            }
        });
        this.falseCheckbox = new WynntilsCheckbox(this.method_46426() + 10, this.method_46427() + 90, 20, (class_2561)class_2561.method_43471((String)"screens.wynntils.itemFilter.booleanFalse"), this.state == ConfirmedBoolean.FALSE, 150, (checkbox, b) -> {
            if (b.booleanValue()) {
                this.toggleState(ConfirmedBoolean.FALSE);
            }
        });
        if (filterPair != null) {
            if (filterPair.statFilter().matches(true)) {
                this.state = ConfirmedBoolean.TRUE;
                this.trueCheckbox.selected = true;
                this.falseCheckbox.selected = false;
            } else if (filterPair.statFilter().matches(false)) {
                this.state = ConfirmedBoolean.FALSE;
                this.trueCheckbox.selected = false;
                this.falseCheckbox.selected = true;
            }
        }
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.trueCheckbox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.falseCheckbox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.trueCheckbox.method_25405(mouseX, mouseY)) {
            return this.trueCheckbox.method_25402(mouseX, mouseY, button);
        }
        if (this.falseCheckbox.method_25405(mouseX, mouseY)) {
            return this.falseCheckbox.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public void updateY(int y) {
    }

    @Override
    protected StatProviderAndFilterPair getFilterPair() {
        if (this.state == ConfirmedBoolean.UNCONFIRMED) {
            return null;
        }
        BooleanStatFilter statFilter = new BooleanStatFilter.BooleanStatFilterFactory().fromBoolean(this.state == ConfirmedBoolean.TRUE);
        return new StatProviderAndFilterPair<Boolean>(this.parent.getProvider(), statFilter);
    }

    private void toggleState(ConfirmedBoolean newState) {
        if (this.state == newState) {
            this.state = ConfirmedBoolean.UNCONFIRMED;
        } else if (newState == ConfirmedBoolean.TRUE) {
            this.state = ConfirmedBoolean.TRUE;
            this.falseCheckbox.selected = false;
        } else {
            this.state = ConfirmedBoolean.FALSE;
            this.trueCheckbox.selected = false;
        }
        this.parent.updateQuery();
    }
}

