/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.itemfilter.widgets;

import com.wynntils.core.text.StyledText;
import com.wynntils.screens.itemfilter.ItemFilterScreen;
import com.wynntils.services.itemfilter.type.SortDirection;
import com.wynntils.services.itemfilter.type.SortInfo;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_6382;

public class SortWidget
extends class_339 {
    private final ItemFilterScreen filterScreen;
    private final List<class_4185> buttons = new ArrayList<class_4185>();
    private SortInfo sortInfo;

    public SortWidget(int x, int y, ItemFilterScreen filterScreen, SortInfo sortInfo) {
        super(x, y, 170, 20, (class_2561)class_2561.method_43470((String)"Sort Widget"));
        this.filterScreen = filterScreen;
        this.sortInfo = sortInfo;
        class_4185 sortButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)(sortInfo.direction() == SortDirection.DESCENDING ? "v" : "\u028c")), button -> this.toggleSortDirection()).method_46433(x + this.field_22758 - 50, y).method_46437(30, 20).method_46431();
        class_4185 upButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\ud83e\udc1d"), button -> filterScreen.reorderSort(sortInfo, -1)).method_46433(x + this.field_22758 - 20, y).method_46437(10, 20).method_46431();
        class_4185 downButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\ud83e\udc1f"), button -> filterScreen.reorderSort(sortInfo, 1)).method_46433(x + this.field_22758 - 10, y).method_46437(10, 20).method_46431();
        Pair<Boolean, Boolean> canSortMove = filterScreen.canSortMove(sortInfo);
        upButton.field_22763 = canSortMove.a();
        downButton.field_22763 = canSortMove.b();
        this.buttons.add(sortButton);
        this.buttons.add(upButton);
        this.buttons.add(downButton);
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        RenderUtils.drawRectBorders(poseStack, this.sortInfo.direction() == SortDirection.DESCENDING ? CommonColors.WHITE : CommonColors.BLACK, this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 1.0f, 1.0f);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.sortInfo.provider().getDisplayName()), this.method_46426() + 2, (float)this.method_46427() + (float)this.field_22759 / 2.0f, this.field_22758 - 54, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.0f);
        for (class_4185 button : this.buttons) {
            button.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseY <= (double)this.filterScreen.getProviderMaskTopY() || mouseY >= (double)this.filterScreen.getProviderMaskBottomY()) {
            return false;
        }
        for (class_364 class_3642 : this.buttons) {
            if (!class_3642.method_25405(mouseX, mouseY)) continue;
            return class_3642.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public void method_46419(int y) {
        super.method_46419(y);
        for (class_4185 button : this.buttons) {
            button.method_46419(y);
        }
    }

    private void toggleSortDirection() {
        SortInfo oldSortInfo = this.sortInfo;
        this.sortInfo = new SortInfo(this.sortInfo.direction() == SortDirection.DESCENDING ? SortDirection.ASCENDING : SortDirection.DESCENDING, this.sortInfo.provider());
        this.filterScreen.changeSort(oldSortInfo, this.sortInfo);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

