/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.lootrunpaths.widgets;

import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.lootrunpaths.WynntilsLootrunPathsScreen;
import com.wynntils.screens.maps.MainMapScreen;
import com.wynntils.services.lootrunpaths.LootrunPathInstance;
import com.wynntils.services.lootrunpaths.LootrunPathsService;
import com.wynntils.services.lootrunpaths.type.LootrunPath;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.io.File;
import java.util.Objects;
import net.minecraft.class_156;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class LootrunPathButton
extends WynntilsButton {
    private static final CustomColor BUTTON_COLOR = new CustomColor(181, 174, 151);
    private static final CustomColor BUTTON_COLOR_HOVERED = new CustomColor(121, 116, 101);
    private static final CustomColor TRACKED_BUTTON_COLOR = new CustomColor(176, 197, 148);
    private static final CustomColor TRACKED_BUTTON_COLOR_HOVERED = new CustomColor(126, 211, 106);
    private final LootrunPathInstance lootrun;
    private final WynntilsLootrunPathsScreen screen;

    public LootrunPathButton(int x, int y, int width, int height, LootrunPathInstance lootrun, WynntilsLootrunPathsScreen screen) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Lootrun Button"));
        this.lootrun = lootrun;
        this.screen = screen;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        CustomColor backgroundColor = this.getButtonBackgroundColor();
        RenderUtils.drawRect(poseStack, backgroundColor, this.method_46426(), this.method_46427(), 0.0f, this.field_22758, this.field_22759);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.lootrun.name()), this.method_46426() + 2, this.method_46427() + 1, this.field_22758 - 3, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE, 1.0f);
    }

    private CustomColor getButtonBackgroundColor() {
        if (this.isLoaded()) {
            return this.field_22762 ? TRACKED_BUTTON_COLOR_HOVERED : TRACKED_BUTTON_COLOR;
        }
        return this.field_22762 ? BUTTON_COLOR_HOVERED : BUTTON_COLOR;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isLoaded()) {
                Services.LootrunPaths.clearCurrentLootrun();
            } else {
                Services.LootrunPaths.tryLoadLootrun(this.lootrun.name());
            }
            return true;
        }
        if (button == 2) {
            class_156.method_668().method_672(LootrunPathsService.LOOTRUNS);
            return true;
        }
        if (button == 1) {
            if ((KeyboardUtils.isKeyDown(340) || KeyboardUtils.isKeyDown(344)) && !this.isLoaded()) {
                this.tryDeleteLootrun();
                return true;
            }
            LootrunPath path = this.lootrun.path();
            class_2374 start = (class_2374)path.points().getFirst();
            McUtils.mc().method_1507(MainMapScreen.create((float)start.method_10216(), (float)start.method_10215()));
            return true;
        }
        return true;
    }

    public void method_25306() {
    }

    private void tryDeleteLootrun() {
        File file = new File(LootrunPathsService.LOOTRUNS, this.lootrun.name() + ".json");
        file.delete();
        this.screen.reloadElements();
    }

    private boolean isLoaded() {
        LootrunPathInstance currentLootrun = Services.LootrunPaths.getCurrentLootrun();
        return currentLootrun != null && Objects.equals(currentLootrun.name(), this.lootrun.name());
    }

    public LootrunPathInstance getLootrun() {
        return this.lootrun;
    }
}

