/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.maps.widgets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.screens.maps.PoiCreationScreen;
import com.wynntils.screens.maps.PoiManagementScreen;
import com.wynntils.services.map.pois.CustomPoi;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3417;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_6382;

public class PoiManagerWidget
extends class_339 {
    private final boolean selected;
    private final boolean selectionMode;
    private final class_4185 editButton;
    private final class_4185 deleteButton;
    private final class_4185 upButton;
    private final class_4185 downButton;
    private final class_4185 selectButton;
    private final CustomColor color;
    private final CustomPoi poi;
    private final float dividedWidth;
    private final PoiManagementScreen managementScreen;

    public PoiManagerWidget(int x, int y, int width, int height, CustomPoi poi, PoiManagementScreen managementScreen, float dividedWidth, boolean selectionMode, boolean selected) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)poi.getName()));
        this.poi = poi;
        this.managementScreen = managementScreen;
        this.dividedWidth = dividedWidth;
        this.selectionMode = selectionMode;
        this.selected = selected;
        int manageButtonsWidth = (int)(dividedWidth * 4.0f);
        this.color = poi.getVisibility() == CustomPoi.Visibility.HIDDEN ? CommonColors.GRAY : CommonColors.WHITE;
        this.editButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.edit"), button -> McUtils.mc().method_1507(PoiCreationScreen.create(managementScreen, poi))).method_46433(x + width - 20 - manageButtonsWidth * 2, y).method_46437(manageButtonsWidth, 20).method_46431();
        this.deleteButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.poiManagementGui.delete"), button -> managementScreen.deletePoi(poi, true)).method_46433(x + width - 20 - manageButtonsWidth, y).method_46437(manageButtonsWidth, 20).method_46431();
        this.upButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\u028c"), button -> managementScreen.updatePoiPosition(poi, -1)).method_46433(x + width - 20, y).method_46437(10, 20).method_46431();
        this.downButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"v"), button -> managementScreen.updatePoiPosition(poi, 1)).method_46433(x + width - 10, y).method_46437(10, 20).method_46431();
        class_5250 selectButtonText = selected ? class_2561.method_43471((String)"screens.wynntils.poiManagementGui.deselect") : class_2561.method_43471((String)"screens.wynntils.poiManagementGui.select");
        this.selectButton = new class_4185.class_7840((class_2561)selectButtonText, button -> managementScreen.selectPoi(poi)).method_46433(x + width - (manageButtonsWidth * 2 + 20), y).method_46437(manageButtonsWidth * 2 + 20, 20).method_46431();
        List<CustomPoi> pois = managementScreen.getPois();
        if (pois.indexOf(poi) == 0) {
            this.upButton.field_22763 = false;
        }
        if (pois.indexOf(poi) == pois.size() - 1) {
            this.downButton.field_22763 = false;
        }
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_4587 poseStack = guiGraphics.method_51448();
        this.renderIcon(poseStack);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.poi.getName()), this.method_46426() + (int)(this.dividedWidth * 3.0f), this.method_46427() + 10, (int)(this.dividedWidth * 15.0f), this.color, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 1.0f);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(String.valueOf(this.poi.getLocation().getX())), this.method_46426() + (int)(this.dividedWidth * 20.0f), this.method_46427() + 10, this.color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        Optional<Integer> poiY = this.poi.getLocation().getY();
        FontRenderer.getInstance().renderText(poseStack, poiY.map(integer -> StyledText.fromString(String.valueOf(integer))).orElse(StyledText.EMPTY), this.method_46426() + (int)(this.dividedWidth * 23.0f), this.method_46427() + 10, this.color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(String.valueOf(this.poi.getLocation().getZ())), this.method_46426() + (int)(this.dividedWidth * 26.0f), this.method_46427() + 10, this.color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        if (this.selectionMode) {
            this.selectButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            RenderUtils.drawRectBorders(poseStack, this.selected ? CommonColors.ORANGE : CommonColors.WHITE, this.method_46426(), this.method_46427() + 1, this.method_46426() + this.field_22758, this.method_46427() + this.field_22759 - 1, 0.0f, 1.0f);
        } else {
            this.editButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            this.deleteButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            this.upButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            this.downButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean clickedButton;
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        if (button == 2) {
            McUtils.playSoundUI(class_3417.field_14627);
            MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(this.poi.getLocation().asLocation(), this.poi.getIcon(), this.poi.getColor(), this.poi.getColor(), this.poi.getName());
            return true;
        }
        if (button == 1) {
            MarkerModel.USER_WAYPOINTS_PROVIDER.removeLocation(this.poi.getLocation().asLocation());
            return true;
        }
        if (this.selectionMode) {
            clickedButton = this.selectButton.method_25402(mouseX, mouseY, button);
        } else {
            boolean bl = clickedButton = this.editButton.method_25402(mouseX, mouseY, button) || this.deleteButton.method_25402(mouseX, mouseY, button) || this.upButton.method_25402(mouseX, mouseY, button) || this.downButton.method_25402(mouseX, mouseY, button);
        }
        if (clickedButton) {
            return clickedButton;
        }
        this.managementScreen.selectPoi(this.poi);
        return true;
    }

    private void renderIcon(class_4587 poseStack) {
        float[] poiColor = CustomColor.fromInt(this.poi.getColor().asInt()).asFloatArray();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)poiColor[0], (float)poiColor[1], (float)poiColor[2], (float)1.0f);
        RenderUtils.drawTexturedRect(poseStack, this.poi.getIcon(), (float)this.method_46426() + this.dividedWidth - (float)this.poi.getIcon().width() / 2.0f, (float)(this.method_46427() + 10) - (float)this.poi.getIcon().height() / 2.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

