/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.partymanagement;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.WynntilsGridLayoutScreen;
import com.wynntils.screens.base.widgets.InfoButton;
import com.wynntils.screens.base.widgets.TextInputBoxWidget;
import com.wynntils.screens.partymanagement.widgets.CreateLeaveButton;
import com.wynntils.screens.partymanagement.widgets.PartyMemberWidget;
import com.wynntils.screens.partymanagement.widgets.SuggestionPlayerWidget;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public final class PartyManagementScreen
extends WynntilsGridLayoutScreen {
    private static final Pattern INVITE_REPLACER = Pattern.compile("[^\\w, ]+");
    private static final Pattern COMMA_REPLACER = Pattern.compile("[,; ]+");
    private static final int START_HEIGHT = 8;
    private static final int PARTY_LIST_DIV_HEIGHT = 14;
    private static final int SUGGESTION_LIST_DIV_HEIGHT = 22;
    private static final int MGMT_ROW_DIV_HEIGHT = 14;
    private int mgmtButtonWidth;
    private TextInputBoxWidget inviteInput;
    private class_4185 inviteButton;
    private class_4185 kickOfflineButton;
    private CreateLeaveButton createLeaveButton;
    private List<SuggestionPlayerWidget> suggestedPlayersWidgets = new ArrayList<SuggestionPlayerWidget>();
    private List<PartyMemberWidget> partyMembersWidgets = new ArrayList<PartyMemberWidget>();

    private PartyManagementScreen() {
        super((class_2561)class_2561.method_43470((String)"Party Management Screen"));
    }

    public static class_437 create() {
        return new PartyManagementScreen();
    }

    @Override
    public void doInit() {
        super.doInit();
        this.mgmtButtonWidth = (int)(this.dividedWidth * 8.0f) - 2;
        this.refreshAll();
        this.inviteInput = new TextInputBoxWidget((int)(this.dividedWidth * 36.0f), (int)(this.dividedHeight * 8.0f) + 1, (int)(this.dividedWidth * 57.0f - this.dividedWidth * 36.0f) - 1, 20, null, this, this.inviteInput);
        this.method_37063((class_364)this.inviteInput);
        this.inviteButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.partyManagementGui.invite"), button -> this.inviteFromField()).method_46433((int)(this.dividedWidth * 57.0f) + 1, (int)(this.dividedHeight * 8.0f) + 1).method_46437((int)(this.dividedWidth * 3.0f) - 1, 20).method_46431();
        this.method_37063((class_364)this.inviteButton);
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.partyManagementGui.refreshButton").method_27692(class_124.field_1060), button -> this.refreshAll()).method_46433((int)(this.dividedWidth * 36.0f) + 1, (int)(this.dividedHeight * 14.0f)).method_46437(this.mgmtButtonWidth, 20).method_46431());
        this.kickOfflineButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.partyManagementGui.kickOfflineButton").method_27692(class_124.field_1061), button -> Models.Party.partyKickOffline()).method_46433((int)(this.dividedWidth * 44.0f) + 1, (int)(this.dividedHeight * 14.0f)).method_46437(this.mgmtButtonWidth, 20).method_46431();
        this.method_37063((class_364)this.kickOfflineButton);
        this.method_37063((class_364)new InfoButton((int)(this.dividedWidth * 2.0f), (int)(this.dividedHeight * 58.0f), (class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.partyManagementGui.legend").method_27692(class_124.field_1073)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.partyManagementGui.self").method_27692(class_124.field_1067)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.partyManagementGui.leader").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.partyManagementGui.offline").method_27692(class_124.field_1055)).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"screens.wynntils.partyManagementGui.friend").method_27692(class_124.field_1060))));
    }

    @Override
    public void doRender(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        class_4587 poseStack = guiGraphics.method_51448();
        boolean inParty = Models.Party.isInParty();
        this.createLeaveButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.kickOfflineButton.field_22763 = inParty && !Models.Party.getOfflineMembers().isEmpty() && Models.Party.isPartyLeader(McUtils.playerName());
        this.inviteButton.field_22763 = !this.inviteInput.getTextBoxInput().isBlank();
        String inviteFieldHeader = class_1074.method_4662((String)"screens.wynntils.partyManagementGui.inviteFieldHeader1", (Object[])new Object[0]) + String.valueOf(class_124.field_1080) + class_1074.method_4662((String)"screens.wynntils.partyManagementGui.inviteFieldHeader2", (Object[])new Object[0]);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(inviteFieldHeader), this.dividedWidth * 36.0f, this.dividedWidth * 60.0f, this.dividedHeight * 8.0f - FontRenderer.getInstance().calculateRenderHeight(StyledText.fromString(inviteFieldHeader), this.dividedWidth * 24.0f), this.dividedHeight * 8.0f, this.dividedWidth * 24.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL);
        if (inParty) {
            Object[] objectArray = new Object[2];
            objectArray[0] = Models.Party.getPartyMembers().size();
            objectArray[1] = 10;
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.partyManagementGui.members", (Object[])objectArray)), this.dividedWidth * 4.0f, this.dividedHeight * 8.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 2.0f);
            RenderUtils.drawRect(poseStack, CommonColors.WHITE, this.dividedWidth * 4.0f, this.dividedHeight * 14.0f, 0.0f, this.dividedWidth * 30.0f - this.dividedWidth * 2.0f, 1.0f);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.partyManagementGui.head", (Object[])new Object[0])), this.dividedWidth * 5.0f, this.dividedHeight * 14.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.partyManagementGui.name", (Object[])new Object[0])), this.dividedWidth * 7.0f, this.dividedHeight * 14.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.partyManagementGui.promote", (Object[])new Object[0])), this.dividedWidth * 22.0f, this.dividedHeight * 14.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.partyManagementGui.kick", (Object[])new Object[0])), this.dividedWidth * 26.0f, this.dividedHeight * 14.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.partyManagementGui.priority", (Object[])new Object[0])), this.dividedWidth * 30.0f, this.dividedHeight * 14.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
            this.partyMembersWidgets.forEach(widget -> widget.method_25394(guiGraphics, mouseX, mouseY, partialTick));
        } else {
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.partyManagementGui.notInParty", (Object[])new Object[0])), this.dividedWidth * 4.0f, this.dividedWidth * 30.0f, this.dividedHeight * 14.0f, (float)this.field_22790 - this.dividedHeight * 14.0f, this.dividedWidth * 30.0f - this.dividedWidth * 4.0f, CustomColor.NONE, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 2.0f);
        }
        RenderUtils.drawRect(poseStack, CommonColors.WHITE, this.dividedWidth * 36.0f, this.dividedHeight * 22.0f, 0.0f, this.dividedWidth * 60.0f - this.dividedWidth * 36.0f, 1.0f);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.partyManagementGui.head", (Object[])new Object[0])), this.dividedWidth * 37.0f, this.dividedHeight * 22.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.partyManagementGui.suggestions", (Object[])new Object[0])), this.dividedWidth * 39.0f, this.dividedHeight * 22.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(class_1074.method_4662((String)"screens.wynntils.partyManagementGui.invite", (Object[])new Object[0])), this.dividedWidth * 58.0f, this.dividedHeight * 22.0f, CommonColors.WHITE, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM, TextShadow.NORMAL);
        this.suggestedPlayersWidgets.forEach(widget -> widget.method_25394(guiGraphics, mouseX, mouseY, partialTick));
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (this.createLeaveButton.method_25405(mouseX, mouseY)) {
            return this.createLeaveButton.method_25402(mouseX, mouseY, button);
        }
        for (class_339 class_3392 : this.partyMembersWidgets) {
            if (!class_3392.method_25405(mouseX, mouseY)) continue;
            return class_3392.method_25402(mouseX, mouseY, button);
        }
        for (class_339 class_3393 : this.suggestedPlayersWidgets) {
            if (!class_3393.method_25405(mouseX, mouseY)) continue;
            return class_3393.method_25402(mouseX, mouseY, button);
        }
        return super.doMouseClicked(mouseX, mouseY, button);
    }

    public void reloadCreateLeaveButton() {
        this.createLeaveButton = new CreateLeaveButton((int)(this.dividedWidth * 52.0f) + 1, (int)(this.dividedHeight * 14.0f), this.mgmtButtonWidth, 20);
    }

    public void reloadMembersWidgets() {
        this.partyMembersWidgets = new ArrayList<PartyMemberWidget>();
        ArrayList<String> partyMembers = new ArrayList<String>(Models.Party.getPartyMembers());
        for (int i = 0; i < partyMembers.size(); ++i) {
            String playerName = (String)partyMembers.get(i);
            if (playerName == null) continue;
            this.partyMembersWidgets.add(new PartyMemberWidget(this.dividedWidth * 4.0f, this.dividedHeight * 16.0f + (float)(i * 20), (int)(this.dividedWidth * 28.0f) - (int)(this.dividedWidth * 2.0f), 20, playerName, Models.Party.getOfflineMembers().contains(playerName), 26.0f));
        }
    }

    public void reloadSuggestedPlayersWidgets() {
        ArrayList<String> suggestedPlayers = new ArrayList<String>(Models.Friends.getOnlineFriends().keySet());
        suggestedPlayers.removeAll(Models.Party.getPartyMembers());
        suggestedPlayers.sort(String.CASE_INSENSITIVE_ORDER);
        this.suggestedPlayersWidgets = new ArrayList<SuggestionPlayerWidget>();
        for (int i = 0; i < suggestedPlayers.size(); ++i) {
            boolean isOffline;
            String playerName = (String)suggestedPlayers.get(i);
            boolean bl = isOffline = !Models.Friends.getOnlineFriends().containsKey(playerName);
            if (playerName == null) continue;
            this.suggestedPlayersWidgets.add(new SuggestionPlayerWidget(this.dividedWidth * 36.0f, this.dividedHeight * (float)(23 + i * 3), (int)(this.dividedWidth * 60.0f - this.dividedWidth * 36.0f), 20, playerName, isOffline, 24.0f));
        }
    }

    private void inviteFromField() {
        String fieldText = INVITE_REPLACER.matcher(this.inviteInput.getTextBoxInput()).replaceAll("");
        if ((fieldText = COMMA_REPLACER.matcher(fieldText).replaceAll(",")).isBlank()) {
            return;
        }
        HashSet<String> toInvite = new HashSet<String>(List.of(fieldText.split(",")));
        toInvite.removeAll(Models.Party.getPartyMembers());
        toInvite.forEach(Models.Party::partyInvite);
        this.inviteInput.setTextBoxInput("");
    }

    private void refreshAll() {
        Models.Party.requestData();
        Models.Friends.requestData();
        this.reloadCreateLeaveButton();
        this.reloadMembersWidgets();
        this.reloadSuggestedPlayersWidgets();
    }
}

