/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.partymanagement.widgets;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.partymanagement.widgets.AbstractPlayerListEntryWidget;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class PartyMemberWidget
extends AbstractPlayerListEntryWidget {
    private final class_4185 promoteButton;
    private final class_4185 kickButton;
    private final class_4185 disbandButton;
    private final class_4185 moveUpButton;
    private final class_4185 moveDownButton;

    public PartyMemberWidget(float x, float y, int width, int height, String playerName, boolean isOffline, float gridDivisions) {
        super((int)x, (int)y, width, height, playerName, isOffline, gridDivisions);
        int baseButtonWidth = (int)((float)this.field_22758 / gridDivisions);
        this.promoteButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.partyManagementGui.promote"), button -> Models.Party.partyPromote(playerName)).method_46433((int)((float)this.method_46426() + (float)this.field_22758 / this.gridDivisions * 16.0f) + 1, this.method_46427()).method_46437(baseButtonWidth * 4, height).method_46431();
        this.kickButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.partyManagementGui.kick"), button -> Models.Party.partyKick(playerName)).method_46433((int)((float)this.method_46426() + (float)this.field_22758 / this.gridDivisions * 20.0f) + 1, this.method_46427()).method_46437(baseButtonWidth * 4, height).method_46431();
        this.disbandButton = new class_4185.class_7840((class_2561)class_2561.method_43471((String)"screens.wynntils.partyManagementGui.disband"), button -> Models.Party.partyDisband()).method_46433((int)((float)this.method_46426() + (float)this.field_22758 / this.gridDivisions * 20.0f) + 1, this.method_46427()).method_46437(baseButtonWidth * 4, height).method_46431();
        this.moveUpButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\ud83e\udc1d"), button -> Models.Party.increasePlayerPriority(playerName)).method_46433((int)((float)this.method_46426() + (float)this.field_22758 / this.gridDivisions * 24.0f) + 1, this.method_46427()).method_46437(baseButtonWidth * 2, height).method_46431();
        this.moveDownButton = new class_4185.class_7840((class_2561)class_2561.method_43470((String)"\ud83e\udc1f"), button -> Models.Party.decreasePlayerPriority(playerName)).method_46433((int)((float)this.method_46426() + (float)this.field_22758 / this.gridDivisions * 26.0f) + 1, this.method_46427()).method_46437(baseButtonWidth * 2, height).method_46431();
        if (Models.Party.isPartyLeader(playerName)) {
            this.promoteButton.field_22763 = false;
            this.kickButton.field_22763 = false;
        } else {
            this.disbandButton.field_22763 = false;
        }
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        class_4587 poseStack = guiGraphics.method_51448();
        CustomColor color = CommonColors.WHITE;
        if (Models.Party.isPartyLeader(this.playerName)) {
            color = CommonColors.YELLOW;
        } else if (Models.Friends.getFriends().contains(this.playerName)) {
            color = CommonColors.GREEN;
        }
        String prefix = "";
        if (this.isOffline) {
            prefix = class_124.field_1055.toString();
        } else if (this.playerName.equals(McUtils.playerName())) {
            prefix = class_124.field_1067.toString();
        }
        StyledText formattedPlayerName = StyledText.fromString(prefix + this.playerName);
        FontRenderer.getInstance().renderText(poseStack, formattedPlayerName, (float)this.method_46426() + (float)this.field_22758 / this.gridDivisions * 3.0f, this.method_46427() + this.field_22759 / 2, color, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.NORMAL);
        this.moveUpButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.moveDownButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (!Models.Party.isPartyLeader(McUtils.playerName())) {
            return;
        }
        if (Models.Party.isPartyLeader(this.playerName)) {
            this.disbandButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        } else {
            this.promoteButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            this.kickButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.moveUpButton.method_25402(mouseX, mouseY, button) || this.moveDownButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (!Models.Party.isPartyLeader(McUtils.playerName())) {
            return false;
        }
        return this.promoteButton.method_25402(mouseX, mouseY, button) || this.kickButton.method_25402(mouseX, mouseY, button) || this.disbandButton.method_25402(mouseX, mouseY, button);
    }
}

